/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.tree;

import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.itsnat.comp.ItsNatComponentUI;
import org.itsnat.comp.tree.ItsNatTree;
import org.itsnat.comp.tree.ItsNatTreeCellEditor;
import org.itsnat.comp.tree.ItsNatTreeCellRenderer;
import org.itsnat.comp.tree.ItsNatTreeCellUI;
import org.itsnat.comp.tree.ItsNatTreeStructure;
import org.itsnat.comp.tree.ItsNatTreeUI;
import org.itsnat.core.ClientDocument;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.NameValue;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.comp.ItsNatComponentInternal;
import org.itsnat.impl.comp.ItsNatElementComponentImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByClientImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByClientJoystickImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByDocImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByDocJoystickImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersJoystick;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersJoystickSharedImpl;
import org.itsnat.impl.comp.listener.JoystickModeComponent;
import org.itsnat.impl.comp.mgr.ItsNatDocComponentManagerImpl;
import org.itsnat.impl.comp.tree.DefaultRowMapperImpl;
import org.itsnat.impl.comp.tree.ItsNatTreeUIImpl;
import org.itsnat.impl.comp.tree.TreeCellEditorProcessor;
import org.itsnat.impl.comp.tree.TreeSelectionModelMgrImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MouseEvent;

public abstract class ItsNatTreeImpl
extends ItsNatElementComponentImpl
implements ItsNatTree,
ItsNatComponentInternal,
TreeModelListener,
JoystickModeComponent {
    protected boolean enabled = true;
    protected TreeSelectionModelMgrImpl selModelMgr;
    protected ItsNatTreeCellRenderer renderer;
    protected TreeCellEditorProcessor editorProcessor = new TreeCellEditorProcessor(this);
    protected EventListenerList expansionListenerList = new EventListenerList();
    protected EventListenerList willExpandListenerList = new EventListenerList();
    protected boolean expandsSelectedPaths = false;
    protected boolean treeTable;
    protected boolean rootless;
    protected ItsNatTreeStructure structure;
    protected int toggleClickCount = 2;
    protected DefaultRowMapperImpl rowMapper = new DefaultRowMapperImpl(this);
    protected boolean selectionUsesKeyboard;

    public ItsNatTreeImpl(boolean treeTable, boolean rootless, Element element, ItsNatTreeStructure structure, NameValue[] artifacts, ItsNatDocComponentManagerImpl componentMgr) {
        super(element, artifacts, componentMgr);
        this.constructor(treeTable, rootless, structure);
    }

    public ItsNatTreeImpl(Element element, NameValue[] artifacts, ItsNatDocComponentManagerImpl componentMgr) {
        super(element, artifacts, componentMgr);
        this.constructor(this.getBooleanArtifactOrAttribute("treeTable", false), this.getBooleanArtifactOrAttribute("rootless", false), null);
    }

    public void constructor(boolean treeTable, boolean rootless, ItsNatTreeStructure structure) {
        this.selectionUsesKeyboard = this.getDefaultSelectionOnComponentsUsesKeyboard();
        this.treeTable = treeTable;
        this.rootless = rootless;
        this.structure = structure != null ? structure : (ItsNatTreeStructure)this.getDeclaredStructure(ItsNatTreeStructure.class);
    }

    @Override
    public ItsNatCompNormalEventListenersByDocImpl createItsNatCompNormalEventListenersByDoc() {
        return new ItsNatCompNormalEventListenersByDocJoystickImpl(this);
    }

    @Override
    public ItsNatCompNormalEventListenersByClientImpl createItsNatCompNormalEventListenersByClient(ClientDocumentImpl clientDoc) {
        return new ItsNatCompNormalEventListenersByClientJoystickImpl(this, clientDoc);
    }

    @Override
    public void enableEventListenersByDoc() {
        super.enableEventListenersByDoc();
        this.enableEventListener("click");
        this.enableEventListener("dblclick");
        this.editorProcessor.enableEventListenersByDoc();
    }

    @Override
    public void disableEventListenersByDoc(boolean updateClient) {
        super.disableEventListenersByDoc(updateClient);
        this.editorProcessor.disableEventListeners(updateClient);
    }

    @Override
    public boolean isTreeTable() {
        return this.treeTable;
    }

    @Override
    public void init() {
        ItsNatDocComponentManagerImpl compMgr = this.getItsNatComponentManagerImpl();
        this.setItsNatTreeCellRenderer(compMgr.createDefaultItsNatTreeCellRenderer());
        super.init();
        this.setItsNatTreeCellEditor(compMgr.createDefaultItsNatTreeCellEditor(null));
    }

    @Override
    public boolean isJoystickMode() {
        return this.getItsNatCompNormalEventListenersByDocJoystick().isJoystickEnabled();
    }

    @Override
    public void setJoystickMode(boolean value) {
        this.getItsNatCompNormalEventListenersByDocJoystick().setJoystickEnabled(value);
    }

    public boolean isJoystickMode(ClientDocument clientDoc) {
        return this.getItsNatCompNormalEventListenersByClientJoystick((ClientDocumentImpl)clientDoc).isJoystickEnabled();
    }

    public void setJoystickMode(ClientDocument clientDoc, boolean value) {
        this.getItsNatCompNormalEventListenersByClientJoystick((ClientDocumentImpl)clientDoc).setJoystickEnabled(value);
    }

    @Override
    public ItsNatCompNormalEventListenersByDocJoystickImpl getItsNatCompNormalEventListenersByDocJoystick() {
        return (ItsNatCompNormalEventListenersByDocJoystickImpl)this.normalEventListenersByDoc;
    }

    public ItsNatCompNormalEventListenersByClientJoystickImpl getItsNatCompNormalEventListenersByClientJoystick(ClientDocumentImpl clientDoc) {
        return (ItsNatCompNormalEventListenersByClientJoystickImpl)this.getItsNatCompNormalEventListenersByClient(clientDoc);
    }

    @Override
    public void unbindModels() {
        this.unsetTreeSelectionModel();
        super.unbindModels();
    }

    @Override
    public void unbindDataModel() {
        TreeModel dataModel = this.getTreeModel();
        dataModel.removeTreeModelListener(this);
    }

    @Override
    public void setDefaultModels() {
        super.setDefaultModels();
        DefaultTreeSelectionModel defSelModel = new DefaultTreeSelectionModel();
        defSelModel.setRowMapper(this.getRowMapper());
        this.setTreeSelectionModel(defSelModel);
    }

    @Override
    public boolean isRootless() {
        return this.rootless;
    }

    @Override
    public int getToggleClickCount() {
        return this.toggleClickCount;
    }

    @Override
    public void setToggleClickCount(int toggleClickCount) {
        if (toggleClickCount < 0 || toggleClickCount > 2) {
            throw new ItsNatException("Bad value, must be between 0-2: " + toggleClickCount, (Object)this);
        }
        this.toggleClickCount = toggleClickCount;
    }

    public boolean mustToggleExpansionStateNode(String evtType) {
        int toggleClickCount = this.getToggleClickCount();
        return toggleClickCount == 1 && evtType.equals("click") && evtType.equals("mouseup") || toggleClickCount == 2 && evtType.equals("dblclick");
    }

    @Override
    public ItsNatTreeStructure getItsNatTreeStructure() {
        return this.structure;
    }

    @Override
    public Object createDefaultStructure() {
        return this.getItsNatComponentManager().createDefaultItsNatTreeStructure();
    }

    public TreeCellEditorProcessor getTreeCellEditorProcessor() {
        return this.editorProcessor;
    }

    @Override
    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.expansionListenerList.add(TreeExpansionListener.class, tel);
    }

    @Override
    public void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.expansionListenerList.remove(TreeExpansionListener.class, tel);
    }

    public boolean hasTreeExpansionListeners() {
        return this.expansionListenerList.getListenerCount() > 0;
    }

    @Override
    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.expansionListenerList.getListeners(TreeExpansionListener.class);
    }

    @Override
    public void addTreeWillExpandListener(TreeWillExpandListener tel) {
        this.willExpandListenerList.add(TreeWillExpandListener.class, tel);
    }

    @Override
    public void removeTreeWillExpandListener(TreeWillExpandListener tel) {
        this.willExpandListenerList.remove(TreeWillExpandListener.class, tel);
    }

    public boolean hasTreeWillExpandListeners() {
        return this.willExpandListenerList.getListenerCount() > 0;
    }

    @Override
    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return (TreeWillExpandListener[])this.willExpandListenerList.getListeners(TreeWillExpandListener.class);
    }

    @Override
    public ItsNatTreeUI getItsNatTreeUI() {
        return (ItsNatTreeUI)this.compUI;
    }

    public ItsNatTreeUIImpl getItsNatTreeUIImpl() {
        return (ItsNatTreeUIImpl)this.compUI;
    }

    public ItsNatTreeUI createDefaultItsNatTreeUI() {
        return new ItsNatTreeUIImpl(this);
    }

    @Override
    public ItsNatComponentUI createDefaultItsNatComponentUI() {
        return this.createDefaultItsNatTreeUI();
    }

    @Override
    public void bindDataModel() {
        TreeModel dataModel = this.getTreeModel();
        dataModel.addTreeModelListener(this);
    }

    @Override
    public void initialSyncWithDataModel() {
        super.initialSyncWithDataModel();
        if (this.selModelMgr != null) {
            this.selModelMgr.syncSelectionModelWithDataModel();
        }
    }

    @Override
    public void initialSyncUIWithDataModel() {
        this.removeRootDOMInternal();
        TreeModel dataModel = this.getTreeModel();
        Object rootNode = dataModel.getRoot();
        this.addRootDOMInternal(rootNode);
    }

    @Override
    public Object createDefaultModelInternal() {
        return this.createDefaultTreeModel();
    }

    @Override
    public TreeModel createDefaultTreeModel() {
        return new DefaultTreeModel(null);
    }

    public TreeSelectionModelMgrImpl getTreeSelectionModelMgr() {
        return this.selModelMgr;
    }

    @Override
    public TreeSelectionModel getTreeSelectionModel() {
        if (this.selModelMgr == null) {
            return null;
        }
        return this.selModelMgr.getTreeSelectionModel();
    }

    @Override
    public void setTreeSelectionModel(TreeSelectionModel selectionModel) {
        this.unsetTreeSelectionModel();
        this.selModelMgr = new TreeSelectionModelMgrImpl(this, selectionModel);
    }

    public void unsetTreeSelectionModel() {
        if (this.selModelMgr != null) {
            this.selModelMgr.dispose();
        }
    }

    @Override
    public ItsNatTreeCellRenderer getItsNatTreeCellRenderer() {
        return this.renderer;
    }

    @Override
    public void setItsNatTreeCellRenderer(ItsNatTreeCellRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public TreeModel getTreeModel() {
        return (TreeModel)this.dataModel;
    }

    @Override
    public void setTreeModel(TreeModel dataModel) {
        this.setDataModel(dataModel);
    }

    @Override
    public ItsNatTreeCellEditor getItsNatTreeCellEditor() {
        TreeCellEditorProcessor editorProcessor = this.getTreeCellEditorProcessor();
        return editorProcessor.getItsNatTreeCellEditor();
    }

    @Override
    public void setItsNatTreeCellEditor(ItsNatTreeCellEditor cellEditor) {
        this.editorProcessor.setItsNatTreeCellEditor(cellEditor);
    }

    public void addRootDOMInternal(Object rootNode) {
        if (rootNode == null) {
            return;
        }
        this.getItsNatTreeUIImpl().addRootNode(rootNode);
        this.addInternalEventListenerJoystickMode();
        if (this.selModelMgr != null) {
            this.selModelMgr.insertElementUpdateModel(new TreePath(rootNode));
        }
    }

    public void removeRootDOMInternal() {
        if (this.selModelMgr != null) {
            this.selModelMgr.removeRootUpdateModel();
        }
        this.removeInternalEventListenerJoystickMode();
        this.getItsNatTreeUIImpl().removeRootNode();
    }

    public void insertTreeNodeDOMInternal(int index, TreePath parentPath) {
        this.getItsNatTreeUIImpl().insertTreeNodeAt(index, parentPath);
        this.addInternalEventListenerJoystickMode(index, parentPath);
        if (this.selModelMgr != null) {
            this.selModelMgr.insertElementUpdateModel(index, parentPath);
        }
    }

    public void removeAllChildTreeNodesDOMInternal(TreePath parentPath) {
        this.removeInternalEventListenerJoystickModeChildNodes(parentPath);
        this.getItsNatTreeUIImpl().removeAllChildTreeNodes(parentPath);
        if (this.selModelMgr != null) {
            this.selModelMgr.removeAllChildElementsUpdateModel(parentPath);
        }
    }

    public void removeTreeNodeDOMInternal(int index, Object childNode, TreePath parentPath) {
        this.removeInternalEventListenerJoystickMode(index, parentPath);
        this.getItsNatTreeUIImpl().removeTreeNodeAt(index, parentPath);
        if (this.selModelMgr != null) {
            this.selModelMgr.removeElementUpdateModel(index, childNode, parentPath);
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        TreePath parentPath = e.getTreePath();
        if (parentPath == null) {
            this.removeRootDOMInternal();
        } else {
            Object[] children;
            int[] indices;
            if (parentPath.getPathCount() == 1) {
                this.removeRootDOMInternal();
                indices = null;
                children = null;
            } else {
                this.removeAllChildTreeNodesDOMInternal(parentPath);
                Object parentNode = parentPath.getLastPathComponent();
                TreeModel dataModel = this.getTreeModel();
                int len = dataModel.getChildCount(parentNode);
                children = new Object[len];
                indices = new int[len];
                for (int i = 0; i < len; ++i) {
                    Object childNode;
                    children[i] = childNode = dataModel.getChild(parentNode, i);
                    indices[i] = i;
                }
            }
            TreeModelEvent eIns = new TreeModelEvent(e.getSource(), e.getPath(), indices, children);
            this.treeNodesInserted(eIns);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        TreePath parentPath = e.getTreePath();
        int[] indices = e.getChildIndices();
        if (indices != null) {
            Object[] children = e.getChildren();
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                Object childNode = children[i];
                this.removeTreeNodeDOMInternal(index, childNode, parentPath);
            }
        } else {
            this.removeRootDOMInternal();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        TreePath parentPath = e.getTreePath();
        int[] indices = e.getChildIndices();
        if (indices != null) {
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                this.insertTreeNodeDOMInternal(index, parentPath);
            }
        } else {
            Object rootNode = parentPath.getLastPathComponent();
            this.addRootDOMInternal(rootNode);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        ItsNatTreeUIImpl treeUI = this.getItsNatTreeUIImpl();
        TreePath parentPath = e.getTreePath();
        int[] indices = e.getChildIndices();
        if (indices != null) {
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                TreePath path = this.toTreePath(index, parentPath);
                treeUI.setTreeNodeValueAt(path, false);
            }
        } else {
            treeUI.setTreeNodeValueAt(parentPath, false);
        }
    }

    public TreePath toTreePath(int i, TreePath parentPath) {
        TreeModel dataModel = this.getTreeModel();
        Object parentNode = parentPath.getLastPathComponent();
        Object childNode = dataModel.getChild(parentNode, i);
        return parentPath.pathByAddingChild(childNode);
    }

    @Override
    public void processNormalEvent(Event evt) {
        String type = evt.getType();
        if (type.equals("click") || type.equals("dblclick") || type.equals("mouseup")) {
            Node nodeClicked = (Node)((Object)evt.getTarget());
            ItsNatTreeUIImpl compUI = this.getItsNatTreeUIImpl();
            ItsNatTreeCellUI nodeInfo = compUI.getItsNatTreeCellUIFromNode(nodeClicked);
            if (nodeInfo != null) {
                Element parentElem = nodeInfo.getParentElement();
                if (parentElem == nodeClicked) {
                    this.selectTreeNode(nodeInfo, evt);
                } else if (DOMUtilInternal.isChildOrSame(nodeClicked, nodeInfo.getHandleElement(), parentElem)) {
                    this.toggleExpansionStateNode(nodeInfo);
                } else if (DOMUtilInternal.isChildOrSame(nodeClicked, nodeInfo.getIconElement(), parentElem)) {
                    if (this.mustToggleExpansionStateNode(type)) {
                        this.toggleExpansionStateNode(nodeInfo);
                    }
                    this.selectTreeNode(nodeInfo, evt);
                } else if (DOMUtilInternal.isChildOrSame(nodeClicked, nodeInfo.getLabelElement(), parentElem)) {
                    if (this.mustToggleExpansionStateNode(type) && (this.getItsNatTreeCellEditor() == null || !type.equals(this.getEditorActivatorEvent()))) {
                        this.toggleExpansionStateNode(nodeInfo);
                    }
                    this.selectTreeNode(nodeInfo, evt);
                }
            }
        }
        super.processNormalEvent(evt);
    }

    public void selectTreeNode(ItsNatTreeCellUI nodeInfo, Event evt) {
        int row = nodeInfo.getRow();
        if (row >= 0) {
            MouseEvent mouseEvt = (MouseEvent)evt;
            boolean toggle = !this.isSelectionUsesKeyboard() ? true : mouseEvt.getCtrlKey();
            boolean extend = mouseEvt.getShiftKey();
            boolean selected = this.selModelMgr.isRowSelected(row);
            this.selModelMgr.changeSelectionModel(row, toggle, extend, selected);
        }
    }

    @Override
    public TreePath getPreviousPath(TreePath path) {
        TreePath prevSiblingPath = this.getPreviousSiblingPath(path);
        if (prevSiblingPath != null) {
            return prevSiblingPath;
        }
        return path.getParentPath();
    }

    @Override
    public TreePath getPreviousSiblingPath(TreePath path) {
        if (path.getParentPath() == null) {
            return null;
        }
        TreeModel dataModel = this.getTreeModel();
        Object dataNode = path.getLastPathComponent();
        TreePath parentPath = path.getParentPath();
        Object parentNode = parentPath.getLastPathComponent();
        int index = dataModel.getIndexOfChild(parentNode, dataNode);
        if (index > 0) {
            Object prevNode = dataModel.getChild(parentNode, index - 1);
            return parentPath.pathByAddingChild(prevNode);
        }
        return null;
    }

    @Override
    public TreePath getNextPath(TreePath path) {
        return this.getNextPath(path, true);
    }

    public TreePath getNextPath(TreePath path, boolean childIncluded) {
        Object dataNode;
        TreeModel dataModel;
        int count;
        if (childIncluded && (count = (dataModel = this.getTreeModel()).getChildCount(dataNode = path.getLastPathComponent())) > 0) {
            Object childNode = dataModel.getChild(dataNode, 0);
            return path.pathByAddingChild(childNode);
        }
        TreePath siblingPath = this.getNextSiblingPath(path);
        if (siblingPath != null) {
            return siblingPath;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return null;
        }
        return this.getNextPath(parentPath, false);
    }

    @Override
    public TreePath getNextSiblingPath(TreePath path) {
        int index;
        if (path.getPathCount() == 1) {
            return null;
        }
        TreeModel dataModel = this.getTreeModel();
        Object dataNode = path.getLastPathComponent();
        TreePath parentPath = path.getParentPath();
        Object parentNode = parentPath.getLastPathComponent();
        int count = dataModel.getChildCount(parentNode);
        if (count > (index = dataModel.getIndexOfChild(parentNode, dataNode)) + 1) {
            Object nextNode = dataModel.getChild(parentNode, index + 1);
            return parentPath.pathByAddingChild(nextNode);
        }
        return null;
    }

    @Override
    public TreePath getLastPath() {
        TreeModel dataModel = this.getTreeModel();
        Object root = dataModel.getRoot();
        if (root == null) {
            return null;
        }
        TreePath rootPath = new TreePath(root);
        return this.getLastPathSubTree(rootPath);
    }

    public TreePath getLastPathSubTree(TreePath path) {
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        TreeModel dataModel = this.getTreeModel();
        int count = dataModel.getChildCount(node);
        if (count == 0) {
            return path;
        }
        Object childNode = dataModel.getChild(node, count - 1);
        TreePath childPath = path.pathByAddingChild(childNode);
        return this.getLastPathSubTree(childPath);
    }

    @Override
    public int getTreeNodeCount() {
        TreeModel dataModel = this.getTreeModel();
        Object root = dataModel.getRoot();
        return this.getTreeNodeCount(root);
    }

    public int getTreeNodeCount(Object node) {
        if (node == null) {
            return 0;
        }
        int count = 1;
        TreeModel dataModel = this.getTreeModel();
        int childCount = dataModel.getChildCount(node);
        for (int i = 0; i < childCount; ++i) {
            Object child = dataModel.getChild(node, i);
            count += this.getTreeNodeCount(child);
        }
        return count;
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        this.getTreeCellEditorProcessor().startEdition(path);
    }

    @Override
    public void startEditingAtRow(int row) {
        this.getTreeCellEditorProcessor().startEdition(row);
    }

    @Override
    public boolean isEditing() {
        return this.getTreeCellEditorProcessor().isEditing();
    }

    @Override
    public TreePath getEditingPath() {
        return this.getTreeCellEditorProcessor().getTreePath();
    }

    @Override
    public int getEditingRow() {
        return this.getTreeCellEditorProcessor().getRow();
    }

    @Override
    public String getEditorActivatorEvent() {
        return this.getTreeCellEditorProcessor().getEditorActivatorEvent();
    }

    @Override
    public void setEditorActivatorEvent(String editorActivatorEvent) {
        this.getTreeCellEditorProcessor().setEditorActivatorEvent(editorActivatorEvent);
    }

    @Override
    public boolean isEditingEnabled() {
        return this.getTreeCellEditorProcessor().isEditingEnabled();
    }

    @Override
    public void setEditingEnabled(boolean value) {
        this.getTreeCellEditorProcessor().setEditingEnabled(value);
    }

    @Override
    public void setExpandsSelectedPaths(boolean newValue) {
        this.expandsSelectedPaths = newValue;
    }

    @Override
    public boolean isExpandsSelectedPaths() {
        return this.expandsSelectedPaths;
    }

    @Override
    public ParamTransport[] getInternalParamTransports(String type, ClientDocumentImpl clientDoc) {
        return null;
    }

    @Override
    public Node createDefaultNode() {
        throw new ItsNatException("There is no default Element and later attachment is not allowed", (Object)this);
    }

    @Override
    public boolean isExpandedNode(TreePath treePath) {
        ItsNatTreeCellUI nodeInfo = this.getItsNatTreeUIImpl().getItsNatTreeCellUIFromTreePath(treePath);
        if (nodeInfo == null) {
            return true;
        }
        return nodeInfo.isExpanded();
    }

    @Override
    public void expandNode(TreePath treePath) {
        ItsNatTreeCellUI nodeInfo = this.getItsNatTreeUIImpl().getItsNatTreeCellUIFromTreePath(treePath);
        if (nodeInfo == null) {
            return;
        }
        this.expandNode(nodeInfo);
    }

    @Override
    public void collapseNode(TreePath treePath) {
        ItsNatTreeCellUI nodeInfo = this.getItsNatTreeUIImpl().getItsNatTreeCellUIFromTreePath(treePath);
        if (nodeInfo == null) {
            return;
        }
        this.collapseNode(nodeInfo);
    }

    @Override
    public void toggleExpansionStateNode(TreePath treePath) {
        ItsNatTreeCellUI nodeInfo = this.getItsNatTreeUIImpl().getItsNatTreeCellUIFromTreePath(treePath);
        if (nodeInfo == null) {
            return;
        }
        this.toggleExpansionStateNode(nodeInfo);
    }

    @Override
    public void expandPath(TreePath path) {
        while (path != null) {
            this.expandNode(path);
            path = path.getParentPath();
        }
    }

    @Override
    public void collapsePath(TreePath path) {
        while (path != null) {
            this.collapseNode(path);
            path = path.getParentPath();
        }
    }

    public void expandNode(ItsNatTreeCellUI nodeInfo) {
        this.expandCollapseNode(nodeInfo, true);
    }

    public void collapseNode(ItsNatTreeCellUI nodeInfo) {
        this.expandCollapseNode(nodeInfo, false);
    }

    public void toggleExpansionStateNode(ItsNatTreeCellUI nodeInfo) {
        this.expandCollapseNode(nodeInfo, !nodeInfo.isExpanded());
    }

    public void expandCollapseNode(ItsNatTreeCellUI treeCellUI, boolean expand) {
        int i;
        EventListener[] listeners;
        boolean wasExpanded = treeCellUI.isExpanded();
        if (wasExpanded == expand) {
            return;
        }
        TreeExpansionEvent event = null;
        TreePath treePath = treeCellUI.getTreePath();
        if (this.hasTreeWillExpandListeners()) {
            event = new TreeExpansionEvent(this, treePath);
            listeners = this.getTreeWillExpandListeners();
            try {
                for (i = 0; i < listeners.length; ++i) {
                    if (expand) {
                        listeners[i].treeWillExpand(event);
                        continue;
                    }
                    listeners[i].treeWillCollapse(event);
                }
            }
            catch (ExpandVetoException ex) {
                return;
            }
        }
        treeCellUI.expand(expand);
        if (this.hasTreeExpansionListeners()) {
            if (event == null) {
                event = new TreeExpansionEvent(this, treePath);
            }
            listeners = this.getTreeExpansionListeners();
            for (i = 0; i < listeners.length; ++i) {
                if (expand) {
                    listeners[i].treeExpanded(event);
                    continue;
                }
                listeners[i].treeCollapsed(event);
            }
        }
    }

    @Override
    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public DefaultRowMapperImpl getDefaultRowMapper() {
        return this.rowMapper;
    }

    @Override
    public TreePath getTreePathForRow(int row) {
        return this.rowMapper.getPathForRow(row);
    }

    public int[] getRowsForPaths(TreePath[] path) {
        return this.rowMapper.getRowsForPaths(path);
    }

    public int getRowCount() {
        return this.rowMapper.getRowCount();
    }

    @Override
    public int getRowForPath(TreePath path) {
        return this.rowMapper.getRowForPath(path);
    }

    public int getRowCountSubTree(TreePath path) {
        if (path == null) {
            return 0;
        }
        return this.rowMapper.getRowCountSubTree(path.getLastPathComponent());
    }

    @Override
    public void setSelectionUsesKeyboard(boolean value) {
        this.selectionUsesKeyboard = value;
    }

    @Override
    public boolean isSelectionUsesKeyboard() {
        return this.selectionUsesKeyboard;
    }

    public Element[] getContentElementList(int fromRow, int toRow) {
        ItsNatTreeUIImpl compUI = this.getItsNatTreeUIImpl();
        int len = toRow - fromRow + 1;
        Element[] elemList = new Element[len * 3];
        for (int row = fromRow; row <= toRow; ++row) {
            ItsNatTreeCellUI cellUI = compUI.getItsNatTreeCellUIFromRow(row);
            if (cellUI == null) continue;
            int pos = (row - fromRow) * 3;
            elemList[pos] = cellUI.getHandleElement();
            elemList[pos + 1] = cellUI.getIconElement();
            elemList[pos + 2] = cellUI.getLabelElement();
        }
        return elemList;
    }

    public Element[] getContentElementList(int index, TreePath parentPath) {
        ItsNatTreeUIImpl compUI = this.getItsNatTreeUIImpl();
        int fromRow = compUI.getRow(index, parentPath);
        int rowCount = compUI.getRowCount(index, parentPath);
        return this.getContentElementList(fromRow, fromRow + rowCount - 1);
    }

    @Override
    public Element[] getContentElementList() {
        ItsNatTreeUIImpl compUI = this.getItsNatTreeUIImpl();
        int len = compUI.getRowCount();
        return this.getContentElementList(0, len - 1);
    }

    public void removeInternalEventListenerJoystickModeChildNodes(TreePath parentPath) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        ItsNatTreeUIImpl compUI = this.getItsNatTreeUIImpl();
        int fromRow = compUI.getRow(parentPath);
        int rowCount = compUI.getRowCount(parentPath);
        Element[] elemList = this.getContentElementList(++fromRow, fromRow + --rowCount - 1);
        ItsNatCompNormalEventListenersJoystickSharedImpl.removeEventListenerJoystick(normalEventListeners, elemList);
    }

    public void addInternalEventListenerJoystickMode() {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        Element[] elemList = this.getContentElementList();
        ItsNatCompNormalEventListenersJoystickSharedImpl.addEventListenerJoystick(normalEventListeners, elemList);
    }

    public void removeInternalEventListenerJoystickMode() {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        Element[] elemList = this.getContentElementList();
        ItsNatCompNormalEventListenersJoystickSharedImpl.removeEventListenerJoystick(normalEventListeners, elemList);
    }

    public void addInternalEventListenerJoystickMode(int index, TreePath parentPath) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        Element[] elemList = this.getContentElementList(index, parentPath);
        ItsNatCompNormalEventListenersJoystickSharedImpl.addEventListenerJoystick(normalEventListeners, elemList);
    }

    public void removeInternalEventListenerJoystickMode(int index, TreePath parentPath) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        Element[] elemList = this.getContentElementList(index, parentPath);
        ItsNatCompNormalEventListenersJoystickSharedImpl.removeEventListenerJoystick(normalEventListeners, elemList);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }
}

