/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.tree;

import java.io.Serializable;
import java.util.LinkedList;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.itsnat.comp.tree.ItsNatTree;

public class DefaultRowMapperImpl
implements RowMapper,
Serializable {
    protected ItsNatTree tree;

    public DefaultRowMapperImpl(ItsNatTree tree) {
        this.tree = tree;
    }

    public TreeModel getTreeModel() {
        return this.tree.getTreeModel();
    }

    @Override
    public int[] getRowsForPaths(TreePath[] path) {
        int[] rows = new int[path.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.getRowForPath(path[i]);
        }
        return rows;
    }

    public int getRowForPath(TreePath path) {
        if (path == null) {
            return -1;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return 0;
        }
        int rowParent = this.getRowForPath(parentPath);
        Object parentNode = parentPath.getLastPathComponent();
        TreeModel dataModel = this.getTreeModel();
        int count = dataModel.getChildCount(parentNode);
        int row = rowParent;
        Object targetNode = path.getLastPathComponent();
        for (int i = 0; i < count; ++i) {
            Object childNode = dataModel.getChild(parentNode, i);
            if (childNode == targetNode) {
                ++row;
                break;
            }
            row += this.getRowCountSubTree(childNode);
        }
        return row;
    }

    public int getRowCount() {
        TreeModel dataModel = this.getTreeModel();
        Object root = dataModel.getRoot();
        if (root == null) {
            return 0;
        }
        return this.getRowCountSubTree(root);
    }

    public int getRowCountSubTree(Object dataNode) {
        if (dataNode == null) {
            return 0;
        }
        int rows = 1;
        TreeModel dataModel = this.getTreeModel();
        int count = dataModel.getChildCount(dataNode);
        for (int i = 0; i < count; ++i) {
            Object dataNodeChild = dataModel.getChild(dataNode, i);
            rows += this.getRowCountSubTree(dataNodeChild);
        }
        return rows;
    }

    public TreePath getPathForRow(int row) {
        if (row < 0) {
            return null;
        }
        TreeModel dataModel = this.getTreeModel();
        Object root = dataModel.getRoot();
        if (root == null) {
            return null;
        }
        if (row == 0) {
            return new TreePath(root);
        }
        LinkedList<Object> path = new LinkedList<Object>();
        int currentRow = 0;
        this.getPathForRow(row, currentRow, root, path, dataModel);
        if (path == null || path.size() == 0) {
            return null;
        }
        return new TreePath(path.toArray());
    }

    public Object getPathForRow(int row, int currentRow, Object dataNode, LinkedList<Object> path, TreeModel dataModel) {
        if (row == currentRow) {
            path.addLast(dataNode);
            return dataNode;
        }
        int count = dataModel.getChildCount(dataNode);
        for (int i = 0; i < count; ++i) {
            Object res;
            Object dataNodeChild = dataModel.getChild(dataNode, i);
            if ((res = this.getPathForRow(row, ++currentRow, dataNodeChild, path, dataModel)) != null) {
                path.addFirst(dataNode);
                return res;
            }
            currentRow += this.getRowCountSubTree(dataNodeChild) - 1;
        }
        return null;
    }
}

