/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.text;

import java.beans.PropertyVetoException;
import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import javax.swing.event.DocumentEvent;
import org.itsnat.comp.text.ItsNatFormattedTextField;
import org.itsnat.comp.text.ItsNatHTMLInputTextFormatted;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.NameValue;
import org.itsnat.impl.comp.mgr.web.ItsNatStfulWebDocComponentManagerImpl;
import org.itsnat.impl.comp.text.ItsNatFormatterDefaultImpl;
import org.itsnat.impl.comp.text.ItsNatFormatterFactoryDefaultImpl;
import org.itsnat.impl.comp.text.ItsNatFormatterFormatBasedImpl;
import org.itsnat.impl.comp.text.ItsNatHTMLInputTextImpl;
import org.w3c.dom.events.Event;
import org.w3c.dom.html.HTMLInputElement;

public class ItsNatHTMLInputTextFormattedImpl
extends ItsNatHTMLInputTextImpl
implements ItsNatHTMLInputTextFormatted {
    protected Object value;
    protected boolean hasFocus;
    protected boolean edited;
    protected boolean editValid;
    protected int focusLostBehavior = 1;
    protected ItsNatFormattedTextField.ItsNatFormatterFactory factory;
    protected ItsNatFormattedTextField.ItsNatFormatter formatter;

    public ItsNatHTMLInputTextFormattedImpl(HTMLInputElement element, NameValue[] artifacts, ItsNatStfulWebDocComponentManagerImpl componentMgr) {
        super(element, artifacts, componentMgr);
        this.setItsNatFormatterFactory(this.createDefaultItsNatFormatterFactory());
        this.init();
    }

    @Override
    public void enableEventListenersByDoc() {
        super.enableEventListenersByDoc();
        this.enableEventListener("focus");
        this.enableEventListener("blur");
    }

    @Override
    public int getFocusLostBehavior() {
        return this.focusLostBehavior;
    }

    @Override
    public void setFocusLostBehavior(int behavior) {
        if (behavior != 0 && behavior != 1 && behavior != 3 && behavior != 2) {
            throw new ItsNatException("Value is not valid must be one of: ItsNatFormattedTextField.COMMIT, ItsNatFormattedTextField.COMMIT_OR_REVERT, ItsNatFormattedTextField.PERSIST or ItsNatFormattedTextField.REVERT", (Object)this);
        }
        this.focusLostBehavior = behavior;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws PropertyVetoException {
        this.setValue(value, true, true);
    }

    public void updateDisplay() {
        Object value = this.getValue();
        try {
            this.setValue(value, true, false);
        }
        catch (PropertyVetoException ex) {
            throw new ItsNatException("INTERNAL ERROR");
        }
    }

    public void setValue(Object value, boolean toDisplay, boolean fire) throws PropertyVetoException {
        Object oldValue = this.value;
        if (fire) {
            this.fireVetoableChange("value", oldValue, value);
        }
        this.value = value;
        if (toDisplay) {
            String str;
            try {
                str = this.valueToString(value);
                this.setEditValid(true);
            }
            catch (ParseException ex) {
                this.value = oldValue;
                this.setEditValid(false);
                throw new ItsNatException(ex, (Object)this);
            }
            this.setText(str);
        }
        if (fire) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.setEdited(false);
    }

    @Override
    public void commitEdit() throws ParseException, PropertyVetoException {
        String str = this.getText();
        Object newValue = this.stringToValue(str);
        this.setValue(newValue, false, true);
    }

    @Override
    public boolean isEdited() {
        return this.edited;
    }

    private void setEdited(boolean edited) {
        this.edited = edited;
    }

    public void setEditValid(boolean isValid) {
        this.editValid = isValid;
    }

    @Override
    public boolean isEditValid() {
        return this.editValid;
    }

    public String valueToString(Object value) throws ParseException {
        ItsNatFormattedTextField.ItsNatFormatter formatter = this.getItsNatFormatter();
        return formatter.valueToString(value, this);
    }

    public Object stringToValue(String str) throws ParseException {
        ItsNatFormattedTextField.ItsNatFormatter formatter = this.getItsNatFormatter();
        return formatter.stringToValue(str, this);
    }

    @Override
    public void processNormalEvent(Event evt) {
        String type = evt.getType();
        if (type.equals("focus")) {
            this.setHasFocus(true);
        } else if (type.equals("blur")) {
            this.setHasFocus(false);
        }
        super.processNormalEvent(evt);
    }

    @Override
    public boolean hasFocus() {
        return this.hasFocus;
    }

    public void setHasFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
        this.updateDisplay();
    }

    @Override
    public void postHandleEventOnChange(Event evt) {
        block7: {
            super.postHandleEventOnChange(evt);
            int fb = this.getFocusLostBehavior();
            if (fb == 0 || fb == 1) {
                try {
                    this.commitEdit();
                    this.updateDisplay();
                }
                catch (ParseException ex) {
                    this.setEditValid(false);
                    if (fb == 1) {
                        this.updateDisplay();
                    }
                    break block7;
                }
                catch (PropertyVetoException ex) {
                    this.setEditValid(false);
                    if (fb == 1) {
                        this.updateDisplay();
                    }
                    break block7;
                }
            }
            if (fb == 2) {
                this.updateDisplay();
            }
        }
    }

    @Override
    public void postHandleEventOnKeyUp(Event evt) {
        super.postHandleEventOnKeyUp(evt);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        super.insertUpdate(e);
        this.setEdited(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        super.removeUpdate(e);
        this.setEdited(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        super.changedUpdate(e);
    }

    @Override
    public ItsNatFormattedTextField.ItsNatFormatterFactory createDefaultItsNatFormatterFactory() {
        return new ItsNatFormatterFactoryDefaultImpl();
    }

    @Override
    public ItsNatFormattedTextField.ItsNatFormatterFactory getItsNatFormatterFactory() {
        return this.factory;
    }

    @Override
    public void setItsNatFormatterFactory(ItsNatFormattedTextField.ItsNatFormatterFactory factory) {
        this.factory = factory;
    }

    @Override
    public ItsNatFormattedTextField.ItsNatFormatter getItsNatFormatter() {
        ItsNatFormattedTextField.ItsNatFormatter formatter = this.formatter;
        if (formatter == null) {
            ItsNatFormattedTextField.ItsNatFormatterFactory factory = this.getItsNatFormatterFactory();
            if (factory != null) {
                formatter = factory.getItsNatFormatter(this);
            }
            if (formatter == null) {
                formatter = this.getDefaultFormatterOfValue(this.getValue());
            }
        }
        if (formatter == null) {
            throw new ItsNatException("No formatter is available", (Object)this);
        }
        return formatter;
    }

    @Override
    public void setItsNatFormatter(ItsNatFormattedTextField.ItsNatFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void setFormat(Format format) {
        this.setItsNatFormatter(this.createItsNatFormatter(format));
    }

    @Override
    public ItsNatFormattedTextField.ItsNatFormatter createItsNatFormatter(Format format) {
        return new ItsNatFormatterFormatBasedImpl(format);
    }

    public ItsNatFormattedTextField.ItsNatFormatter getDefaultFormatterOfValue(Object value) {
        Format format = null;
        if (value != null) {
            if (value instanceof Date) {
                format = this.getItsNatComponentManager().getItsNatDocument().getDefaultDateFormat();
            } else if (value instanceof Number) {
                format = this.getItsNatComponentManager().getItsNatDocument().getDefaultNumberFormat();
            }
        }
        if (format != null) {
            return new ItsNatFormatterFormatBasedImpl(format);
        }
        return new ItsNatFormatterDefaultImpl();
    }
}

