/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.table;

import javax.swing.table.TableModel;
import org.itsnat.comp.ItsNatComponent;
import org.itsnat.comp.table.ItsNatTableCellEditor;
import org.itsnat.comp.table.ItsNatTableCellUI;
import org.itsnat.comp.table.ItsNatTableUI;
import org.itsnat.impl.comp.inplace.EditorProcessorBaseImpl;
import org.itsnat.impl.comp.table.ItsNatTableImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

public class TableCellEditorProcessor
extends EditorProcessorBaseImpl {
    protected ItsNatTableCellUI cellInfo;

    public TableCellEditorProcessor(ItsNatTableImpl compParent) {
        super(compParent);
    }

    public ItsNatTableImpl getItsNatTable() {
        return (ItsNatTableImpl)this.compParent;
    }

    public ItsNatTableCellEditor getItsNatTableCellEditor() {
        return (ItsNatTableCellEditor)this.cellEditor;
    }

    public void setItsNatTableCellEditor(ItsNatTableCellEditor cellEditor) {
        this.setCellEditor(cellEditor);
    }

    public void setCurrentContext(ItsNatTableCellUI cellInfo) {
        this.cellInfo = cellInfo;
    }

    public int getRow() {
        if (this.cellInfo == null) {
            return -1;
        }
        return this.cellInfo.getRowIndex();
    }

    public int getColumn() {
        if (this.cellInfo == null) {
            return -1;
        }
        return this.cellInfo.getColumnIndex();
    }

    public void startEdition(int row, int column) {
        if (this.prepareEdition()) {
            this.openEditor(row, column);
        }
    }

    protected void openEditor(int row, int column) {
        ItsNatTableUI bodyUI = this.getItsNatTable().getItsNatTableUI();
        ItsNatTableCellUI cellInfo = bodyUI.getItsNatTableCellUIAt(row, column);
        this.openEditor(cellInfo);
    }

    @Override
    protected void openEditor(Event evt) {
        Node nodeClicked = (Node)((Object)evt.getTarget());
        ItsNatTableUI bodyUI = this.getItsNatTable().getItsNatTableUI();
        ItsNatTableCellUI cellInfo = bodyUI.getItsNatTableCellUIFromNode(nodeClicked);
        this.openEditor(cellInfo);
    }

    protected void openEditor(ItsNatTableCellUI cellInfo) {
        if (cellInfo != null) {
            int row = cellInfo.getRowIndex();
            int column = cellInfo.getColumnIndex();
            ItsNatTableImpl table = this.getItsNatTable();
            TableModel dataModel = table.getTableModel();
            if (dataModel.isCellEditable(row, column)) {
                this.setCurrentContext(cellInfo);
                Element cellContentElem = cellInfo.getCellContentElement();
                Object value = dataModel.getValueAt(row, column);
                boolean isSelected = table.isCellSelected(row, column);
                this.beforeShow(cellContentElem);
                ItsNatTableCellEditor cellEditor = this.getItsNatTableCellEditor();
                ItsNatComponent compEditor = cellEditor.getTableCellEditorComponent(table, row, column, value, isSelected, cellContentElem);
                this.afterShow(compEditor);
            }
        }
    }

    @Override
    public void acceptNewValue(Object value) {
        int row = this.cellInfo.getRowIndex();
        int column = this.cellInfo.getColumnIndex();
        this.getItsNatTable().getTableModel().setValueAt(value, row, column);
    }

    @Override
    public void clearCurrentContext() {
        this.setCurrentContext(null);
    }
}

