/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.table;

import org.itsnat.comp.table.ItsNatTable;
import org.itsnat.comp.table.ItsNatTableCellRenderer;
import org.itsnat.comp.table.ItsNatTableCellUI;
import org.itsnat.comp.table.ItsNatTableHeader;
import org.itsnat.comp.table.ItsNatTableHeaderUI;
import org.itsnat.comp.table.ItsNatTableStructure;
import org.itsnat.comp.table.ItsNatTableUI;
import org.itsnat.impl.comp.ItsNatElementComponentUIImpl;
import org.itsnat.impl.comp.table.ItsNatTableCellUIImpl;
import org.itsnat.impl.comp.table.ItsNatTableImpl;
import org.itsnat.impl.comp.table.ItsNatTableStructureCoreAdapterImpl;
import org.itsnat.impl.core.domutil.ElementGroupManagerImpl;
import org.itsnat.impl.core.domutil.ElementListBaseImpl;
import org.itsnat.impl.core.domutil.ElementListImpl;
import org.itsnat.impl.core.domutil.ElementTableImpl;
import org.itsnat.impl.core.domutil.TableCellElementInfoMasterImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ItsNatTableUIImpl
extends ItsNatElementComponentUIImpl
implements ItsNatTableUI {
    protected boolean enabled = true;
    protected ElementTableImpl tableMgr;

    public ItsNatTableUIImpl(ItsNatTableImpl parentComp) {
        super(parentComp);
        ItsNatTableStructure structure = parentComp.getItsNatTableStructure();
        Element tableElem = parentComp.getElement();
        Element bodyElem = structure.getBodyElement(parentComp, tableElem);
        ItsNatTableStructureCoreAdapterImpl structAdapter = new ItsNatTableStructureCoreAdapterImpl(structure, parentComp, null);
        ElementGroupManagerImpl factory = this.getItsNatDocumentImpl().getElementGroupManagerImpl();
        this.tableMgr = factory.createElementTableInternal(bodyElem, true, structAdapter, null);
    }

    @Override
    public Element getBodyElement() {
        return this.tableMgr.getParentElement();
    }

    @Override
    public ItsNatTableHeaderUI getItsNatTableHeaderUI() {
        ItsNatTableHeader header = this.getItsNatTable().getItsNatTableHeader();
        if (header == null) {
            return null;
        }
        return header.getItsNatTableHeaderUI();
    }

    @Override
    public ItsNatTable getItsNatTable() {
        return (ItsNatTable)((Object)this.parentComp);
    }

    public ItsNatTableCellRenderer getItsNatTableCellRenderer() {
        return this.getItsNatTable().getItsNatTableCellRenderer();
    }

    @Override
    public ItsNatTableCellUI getItsNatTableCellUIFromNode(Node node) {
        TableCellElementInfoMasterImpl cellInfo = (TableCellElementInfoMasterImpl)this.tableMgr.getTableCellElementInfoFromNode(node);
        return ItsNatTableCellUIImpl.getItsNatTableCellUI(cellInfo, this);
    }

    @Override
    public ItsNatTableCellUI getItsNatTableCellUIAt(int row, int column) {
        TableCellElementInfoMasterImpl cellInfo = (TableCellElementInfoMasterImpl)this.tableMgr.getTableCellElementInfoAt(row, column);
        return ItsNatTableCellUIImpl.getItsNatTableCellUI(cellInfo, this);
    }

    @Override
    public int getRowCount() {
        return this.tableMgr.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableMgr.getColumnCount();
    }

    public void setRowCount(int rows) {
        this.tableMgr.setRowCount(rows);
    }

    public void setColumnCount(int columns) {
        this.tableMgr.setColumnCount(columns);
    }

    public void setCellValueAt(int rowIndex, int columnIndex, Object aValue, boolean isSelected, boolean hasFocus) {
        Element cellElem = this.getCellElementAt(rowIndex, columnIndex);
        this.setElementValueAt(rowIndex, columnIndex, aValue, isSelected, hasFocus, cellElem, false);
    }

    public void setElementValueAt(int rowIndex, int columnIndex, Object aValue, boolean isSelected, boolean hasFocus, Element cellElem, boolean isNew) {
        Element cellContentElem = this.tableMgr.getCellContentElementAt(rowIndex, columnIndex, cellElem);
        this.tableMgr.prepareRendering(cellContentElem, isNew);
        ItsNatTableCellRenderer renderer = this.getItsNatTableCellRenderer();
        if (renderer != null) {
            renderer.renderTableCell(this.getItsNatTable(), rowIndex, columnIndex, aValue, isSelected, hasFocus, cellContentElem, isNew);
        }
    }

    public Element insertRowAt(int row, Object[] values) {
        Element rowElem = this.tableMgr.insertRowAt(row);
        boolean[] selected = null;
        boolean[] hasFocus = null;
        if (values != null) {
            selected = new boolean[values.length];
            hasFocus = new boolean[values.length];
        }
        this.setRowValuesAt(row, values, selected, hasFocus, rowElem, true);
        return rowElem;
    }

    public void setRowValuesAt(int row, Object[] values, boolean[] selected, boolean[] hasFocus) {
        Element rowElem = this.tableMgr.getRowElementAt(row);
        this.setRowValuesAt(row, values, selected, hasFocus, rowElem, false);
    }

    protected void setRowValuesAt(int row, Object[] values, boolean[] selected, boolean[] hasFocus, Element rowElem, boolean isNew) {
        if (values != null) {
            ElementListImpl columns = (ElementListImpl)this.tableMgr.getColumnsOfRowElementList(row, rowElem);
            int i = 0;
            for (Element columElem : columns.getInternalElementListFree()) {
                this.setElementValueAt(row, i, values[i], selected[i], hasFocus[i], columElem, isNew);
                ++i;
            }
        }
    }

    public void insertColumnAt(int column, Object[] columnData) {
        this.tableMgr.insertColumnAt(column);
        boolean[] selected = null;
        boolean[] hasFocus = null;
        if (columnData != null) {
            selected = new boolean[columnData.length];
            hasFocus = new boolean[columnData.length];
        }
        this.setColumnValuesAt(column, columnData, selected, hasFocus, true);
    }

    public void setColumnValuesAt(int column, Object[] columnData, boolean[] selected, boolean[] hasFocus) {
        this.setColumnValuesAt(column, columnData, selected, hasFocus, false);
    }

    public void setColumnValuesAt(int column, Object[] columnData, boolean[] selected, boolean[] hasFocus, boolean isNew) {
        ElementListImpl rows;
        if (columnData != null && !(rows = this.tableMgr.getRowElementList()).isEmpty()) {
            int row = 0;
            for (Element rowElem : rows.getInternalElementListFree()) {
                ElementListBaseImpl columns = this.tableMgr.getColumnsOfRowElementList(row, rowElem);
                Element cellElem = columns.getElementAt(column);
                this.setElementValueAt(row, column, columnData[row], selected[row], hasFocus[row], cellElem, isNew);
                ++row;
            }
        }
    }

    public void unrenderCell(int rowIndex, int columnIndex) {
        ItsNatTableCellRenderer renderer = this.getItsNatTableCellRenderer();
        if (renderer == null) {
            return;
        }
        Element cellElem = this.getCellElementAt(rowIndex, columnIndex);
        Element cellContentElem = this.tableMgr.getCellContentElementAt(rowIndex, columnIndex, cellElem);
        renderer.unrenderTableCell(this.getItsNatTable(), rowIndex, columnIndex, cellContentElem);
    }

    public void unrenderAllCells() {
        ItsNatTableCellRenderer renderer = this.getItsNatTableCellRenderer();
        if (renderer == null) {
            return;
        }
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                this.unrenderCell(row, col);
            }
        }
    }

    public void removeRowAt(int row) {
        ItsNatTableCellRenderer renderer = this.getItsNatTableCellRenderer();
        if (renderer != null) {
            int colCount = this.getColumnCount();
            for (int col = 0; col < colCount; ++col) {
                this.unrenderCell(row, col);
            }
        }
        this.tableMgr.removeRowAt(row);
    }

    public void removeColumnAt(int column) {
        ItsNatTableCellRenderer renderer = this.getItsNatTableCellRenderer();
        if (renderer != null) {
            int rowCount = this.getRowCount();
            for (int row = 0; row < rowCount; ++row) {
                this.unrenderCell(row, column);
            }
        }
        this.tableMgr.removeColumnAt(column);
    }

    public void removeAllRows() {
        this.unrenderAllCells();
        this.tableMgr.removeAllRows();
    }

    public void removeAllColumns() {
        this.unrenderAllCells();
        this.tableMgr.removeAllColumns();
    }

    @Override
    public Element getRowElementAt(int row) {
        return this.tableMgr.getRowElementAt(row);
    }

    @Override
    public Element getRowContentElementAt(int row) {
        return this.tableMgr.getRowContentElementAt(row);
    }

    @Override
    public Element getCellElementAt(int row, int column) {
        return this.tableMgr.getCellElementAt(row, column);
    }

    @Override
    public Element getCellContentElementAt(int row, int column) {
        return this.tableMgr.getCellContentElementAt(row, column);
    }

    @Override
    public Element[] getCellElementsOfRow(int row) {
        return this.tableMgr.getCellElementsOfRow(row);
    }

    @Override
    public Element[] getCellElementsOfColumn(int column) {
        return this.tableMgr.getCellElementsOfColumn(column);
    }

    @Override
    public boolean isUsePatternMarkupToRender() {
        return this.tableMgr.isUsePatternMarkupToRender();
    }

    @Override
    public void setUsePatternMarkupToRender(boolean value) {
        this.tableMgr.setUsePatternMarkupToRender(value);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

