/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.table;

import java.io.Serializable;
import org.itsnat.comp.table.ItsNatTable;
import org.itsnat.comp.table.ItsNatTableHeader;
import org.itsnat.comp.table.ItsNatTableStructure;
import org.itsnat.core.ItsNatDOMException;
import org.itsnat.core.domutil.ItsNatTreeWalker;
import org.itsnat.impl.core.domutil.ElementListStructureDefaultImpl;
import org.itsnat.impl.core.domutil.ElementTableStructureDefaultImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class ItsNatTableStructureDefaultImpl
implements ItsNatTableStructure,
Serializable {
    protected static final ItsNatTableStructureDefaultImpl SINGLETON = new ItsNatTableStructureDefaultImpl();

    private ItsNatTableStructureDefaultImpl() {
    }

    public static ItsNatTableStructureDefaultImpl newItsNatTableStructureDefault() {
        return SINGLETON;
    }

    @Override
    public Element getHeadElement(ItsNatTable table, Element tableElem) {
        if (tableElem == null) {
            tableElem = table.getElement();
        }
        if (tableElem instanceof HTMLTableElement) {
            HTMLTableElement htmlTableElem = (HTMLTableElement)tableElem;
            return htmlTableElem.getTHead();
        }
        Element firstChild = ItsNatTreeWalker.getFirstChildElement(tableElem);
        Element secondChild = ItsNatTreeWalker.getNextSiblingElement(firstChild);
        if (secondChild == null) {
            return null;
        }
        return firstChild;
    }

    @Override
    public Element getBodyElement(ItsNatTable table, Element tableElem) {
        if (tableElem == null) {
            tableElem = table.getElement();
        }
        if (tableElem instanceof HTMLTableElement) {
            HTMLTableElement htmlTableElem = (HTMLTableElement)tableElem;
            HTMLTableSectionElement tBody = (HTMLTableSectionElement)ItsNatTreeWalker.getFirstChildElementWithTagNameNS(htmlTableElem, "http://www.w3.org/1999/xhtml", "tbody");
            if (tBody == null) {
                throw new ItsNatDOMException("Missing <tbody>", (Node)htmlTableElem);
            }
            return tBody;
        }
        Element firstChild = ItsNatTreeWalker.getFirstChildElement(tableElem);
        Element secondChild = ItsNatTreeWalker.getNextSiblingElement(firstChild);
        if (secondChild == null) {
            return tableElem;
        }
        return secondChild;
    }

    @Override
    public Element getHeaderColumnContentElement(ItsNatTableHeader tableHeader, int index, Element parentElem) {
        if (parentElem == null) {
            parentElem = tableHeader.getItsNatTableHeaderUI().getElementAt(index);
        }
        return ElementListStructureDefaultImpl.getContentElement(index, parentElem);
    }

    @Override
    public Element getRowContentElement(ItsNatTable table, int row, Element rowElem) {
        if (rowElem == null) {
            rowElem = table.getItsNatTableUI().getRowElementAt(row);
        }
        return ElementTableStructureDefaultImpl.getRowContentElement(row, rowElem);
    }

    @Override
    public Element getCellContentElement(ItsNatTable table, int row, int col, Element cellElem) {
        if (cellElem == null) {
            cellElem = table.getItsNatTableUI().getCellElementAt(row, col);
        }
        return ElementTableStructureDefaultImpl.getCellContentElement(row, col, cellElem);
    }
}

