/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.table;

import java.util.ArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.itsnat.comp.table.ItsNatTable;
import org.itsnat.comp.table.ItsNatTableCellEditor;
import org.itsnat.comp.table.ItsNatTableCellRenderer;
import org.itsnat.comp.table.ItsNatTableCellUI;
import org.itsnat.comp.table.ItsNatTableHeader;
import org.itsnat.comp.table.ItsNatTableHeaderCellUI;
import org.itsnat.comp.table.ItsNatTableStructure;
import org.itsnat.comp.table.ItsNatTableUI;
import org.itsnat.core.ClientDocument;
import org.itsnat.core.NameValue;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.comp.ItsNatElementComponentImpl;
import org.itsnat.impl.comp.list.ListSelectionModelMgrImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByClientImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByClientJoystickImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByDocImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByDocJoystickImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersJoystick;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersJoystickSharedImpl;
import org.itsnat.impl.comp.listener.JoystickModeComponent;
import org.itsnat.impl.comp.mgr.ItsNatDocComponentManagerImpl;
import org.itsnat.impl.comp.table.ItsNatTableHeaderImpl;
import org.itsnat.impl.comp.table.ItsNatTableUIImpl;
import org.itsnat.impl.comp.table.TableCellEditorProcessor;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MouseEvent;

public abstract class ItsNatTableImpl
extends ItsNatElementComponentImpl
implements ItsNatTable,
TableModelListener,
JoystickModeComponent {
    protected boolean enabled = true;
    protected ItsNatTableHeaderImpl header;
    protected ItsNatTableCellRenderer renderer;
    protected ListSelectionModelMgrImpl rowSelModelMgr;
    protected ListSelectionModelMgrImpl columnSelModelMgr;
    protected boolean rowSelectionAllowed = true;
    protected boolean columnSelectionAllowed = false;
    protected TableCellEditorProcessor editorProcessor = new TableCellEditorProcessor(this);
    protected boolean selectionUsesKeyboard = this.getDefaultSelectionOnComponentsUsesKeyboard();
    protected ItsNatTableStructure structure;

    public ItsNatTableImpl(Element element, ItsNatTableStructure structure, NameValue[] artifacts, ItsNatDocComponentManagerImpl componentMgr) {
        super(element, artifacts, componentMgr);
        this.structure = structure != null ? structure : (ItsNatTableStructure)this.getDeclaredStructure(ItsNatTableStructure.class);
        this.setItsNatTableCellRenderer(componentMgr.createDefaultItsNatTableCellRenderer());
    }

    @Override
    public void init() {
        Element tableElem;
        ItsNatTableStructure structure = this.getItsNatTableStructure();
        Element headerElem = structure.getHeadElement(this, tableElem = this.getElement());
        if (headerElem != null) {
            this.header = this.createItsNatTableHeader(headerElem);
        }
        super.init();
        ItsNatDocComponentManagerImpl compMgr = this.getItsNatComponentManagerImpl();
        this.setItsNatTableCellEditor(compMgr.createDefaultItsNatTableCellEditor(null));
    }

    @Override
    public ItsNatCompNormalEventListenersByDocImpl createItsNatCompNormalEventListenersByDoc() {
        return new ItsNatCompNormalEventListenersByDocJoystickImpl(this);
    }

    @Override
    public ItsNatCompNormalEventListenersByClientImpl createItsNatCompNormalEventListenersByClient(ClientDocumentImpl clientDoc) {
        return new ItsNatCompNormalEventListenersByClientJoystickImpl(this, clientDoc);
    }

    @Override
    public void enableEventListenersByDoc() {
        super.enableEventListenersByDoc();
        this.enableEventListener("click");
        this.editorProcessor.enableEventListenersByDoc();
    }

    @Override
    public void disableEventListenersByDoc(boolean updateClient) {
        super.disableEventListenersByDoc(updateClient);
        this.editorProcessor.disableEventListeners(updateClient);
    }

    @Override
    public boolean isJoystickMode() {
        return this.getItsNatCompNormalEventListenersByDocJoystick().isJoystickEnabled();
    }

    @Override
    public void setJoystickMode(boolean value) {
        this.getItsNatCompNormalEventListenersByDocJoystick().setJoystickEnabled(value);
    }

    public boolean isJoystickMode(ClientDocument clientDoc) {
        return this.getItsNatCompNormalEventListenersByClientJoystick((ClientDocumentImpl)clientDoc).isJoystickEnabled();
    }

    public void setJoystickMode(ClientDocument clientDoc, boolean value) {
        this.getItsNatCompNormalEventListenersByClientJoystick((ClientDocumentImpl)clientDoc).setJoystickEnabled(value);
    }

    @Override
    public ItsNatCompNormalEventListenersByDocJoystickImpl getItsNatCompNormalEventListenersByDocJoystick() {
        return (ItsNatCompNormalEventListenersByDocJoystickImpl)this.normalEventListenersByDoc;
    }

    public ItsNatCompNormalEventListenersByClientJoystickImpl getItsNatCompNormalEventListenersByClientJoystick(ClientDocumentImpl clientDoc) {
        return (ItsNatCompNormalEventListenersByClientJoystickImpl)this.getItsNatCompNormalEventListenersByClient(clientDoc);
    }

    @Override
    public void setDefaultItsNatComponentUI() {
        if (this.header != null) {
            this.header.setDefaultItsNatComponentUI();
        }
        super.setDefaultItsNatComponentUI();
    }

    @Override
    public void setDefaultModels() {
        super.setDefaultModels();
        if (this.header != null) {
            this.header.setDefaultModels();
        }
        this.setRowSelectionModel(new DefaultListSelectionModel());
        this.setColumnSelectionModel(new DefaultListSelectionModel());
    }

    @Override
    public void unbindModels() {
        if (this.header != null) {
            this.header.unsetListSelectionModel();
        }
        this.unsetRowListSelectionModel();
        this.unsetColumnListSelectionModel();
        super.unbindModels();
    }

    @Override
    public void unbindDataModel() {
        TableModel dataModel = (TableModel)this.getDataModel();
        dataModel.removeTableModelListener(this);
    }

    public TableCellEditorProcessor getTableCellEditorProcessor() {
        return this.editorProcessor;
    }

    public abstract ItsNatTableHeaderImpl createItsNatTableHeader(Element var1);

    @Override
    public ItsNatTableHeader getItsNatTableHeader() {
        return this.getItsNatTableHeaderImpl();
    }

    public ItsNatTableHeaderImpl getItsNatTableHeaderImpl() {
        return this.header;
    }

    @Override
    public ItsNatTableUI getItsNatTableUI() {
        return (ItsNatTableUI)this.compUI;
    }

    public ItsNatTableUIImpl getItsNatTableUIImpl() {
        return (ItsNatTableUIImpl)this.compUI;
    }

    @Override
    public Object createDefaultModelInternal() {
        return this.createDefaultTableModel();
    }

    @Override
    public TableModel createDefaultTableModel() {
        return new DefaultTableModel();
    }

    @Override
    public void bindDataModel() {
        TableModel dataModel = (TableModel)this.getDataModel();
        dataModel.addTableModelListener(this);
    }

    @Override
    public void initialSyncWithDataModel() {
        super.initialSyncWithDataModel();
        TableModel dataModel = this.getTableModel();
        int columns = dataModel.getColumnCount();
        int rows = dataModel.getRowCount();
        this.updateSelectionModelAddedRemoved(columns, this.columnSelModelMgr);
        this.updateSelectionModelAddedRemoved(rows, this.rowSelModelMgr);
    }

    public void syncWithDataModel() {
        this.initialSyncWithDataModel();
    }

    public void insertDOMRow(int row, Object[] values) {
        ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
        compUI.insertRowAt(row, values);
        this.addInternalEventListenerJoystickModeRow(row);
        this.rowSelModelMgr.insertElementUpdateModel(row);
    }

    public void removeDOMRow(int row) {
        this.removeInternalEventListenerJoystickModeRow(row);
        ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
        compUI.removeRowAt(row);
        this.rowSelModelMgr.removeRangeUpdateModel(row, row);
    }

    public void insertDOMColumn(int column, Object[] columData) {
        ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
        TableModel dataModel = this.getTableModel();
        compUI.insertColumnAt(column, columData);
        this.addInternalEventListenerJoystickModeColumn(column);
        ItsNatTableHeaderImpl header = this.getItsNatTableHeaderImpl();
        if (header != null) {
            header.insertDOMColumn(column, dataModel.getColumnName(column));
        }
        this.columnSelModelMgr.insertElementUpdateModel(column);
    }

    public void removeDOMColumn(int column) {
        this.removeInternalEventListenerJoystickModeColumn(column);
        ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
        compUI.removeColumnAt(column);
        ItsNatTableHeaderImpl header = this.getItsNatTableHeaderImpl();
        if (header != null) {
            header.removeDOMColumn(column);
        }
        this.columnSelModelMgr.removeRangeUpdateModel(column, column);
    }

    public void updateDOMRowValues(int row, Object[] rowValues) {
        ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
        boolean[] selected = this.getRowSelectionList(row, this.getTableModel().getColumnCount());
        boolean[] hasFocus = new boolean[selected.length];
        compUI.setRowValuesAt(row, rowValues, selected, hasFocus);
    }

    public void setDOMRowCount(int rows) {
        ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
        int oldRows = compUI.getRowCount();
        if (rows < oldRows) {
            this.removeInternalEventListenerJoystickModeRowRange(rows, oldRows - 1);
        }
        compUI.setRowCount(rows);
        if (rows > oldRows) {
            this.addInternalEventListenerJoystickModeRowRange(oldRows, rows - 1);
        }
        this.updateSelectionModelAddedRemoved(rows, this.rowSelModelMgr);
    }

    public void setDOMColumnCount(int cols) {
        ItsNatTableHeaderImpl header;
        ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
        int oldCols = compUI.getColumnCount();
        if (cols < oldCols) {
            this.removeInternalEventListenerJoystickModeColumnRange(cols, oldCols - 1);
        }
        compUI.setColumnCount(cols);
        if (cols > oldCols) {
            this.addInternalEventListenerJoystickModeColumnRange(oldCols, cols - 1);
        }
        if ((header = this.getItsNatTableHeaderImpl()) != null) {
            header.setDOMColumnCount(cols);
        }
        this.updateSelectionModelAddedRemoved(cols, this.columnSelModelMgr);
    }

    public void updateSelectionModelAddedRemoved(int size, ListSelectionModelMgrImpl selModelMgr) {
        if (selModelMgr != null) {
            selModelMgr.setSize(size);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModel dataModel = (TableModel)e.getSource();
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        int column = e.getColumn();
        int type = e.getType();
        if (column == -1) {
            if (firstRow == -1) {
                this.syncWithDataModel();
                return;
            }
            if (lastRow == Integer.MAX_VALUE) {
                this.syncRowsWithDataModel();
                return;
            }
        }
        switch (type) {
            case 1: {
                if (column == -1) {
                    int colCount = dataModel.getColumnCount();
                    for (int i = firstRow; i <= lastRow; ++i) {
                        Object[] rowValues = this.getRowValues(i, colCount);
                        this.insertDOMRow(i, rowValues);
                    }
                    break;
                }
                Object[] colValues = this.getColumnValues(column);
                this.insertDOMColumn(column, colValues);
                break;
            }
            case 0: {
                if (column == -1) {
                    int colCount = dataModel.getColumnCount();
                    for (int i = firstRow; i <= lastRow; ++i) {
                        Object[] rowValues = this.getRowValues(i, colCount);
                        this.updateDOMRowValues(i, rowValues);
                    }
                } else {
                    ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
                    for (int row = firstRow; row <= lastRow; ++row) {
                        Object obj = dataModel.getValueAt(row, column);
                        boolean isSelected = this.isCellSelected(row, column);
                        compUI.setCellValueAt(row, column, obj, isSelected, false);
                    }
                }
                break;
            }
            case -1: {
                if (column == -1) {
                    for (int i = firstRow; i <= lastRow; ++i) {
                        this.removeDOMRow(firstRow);
                    }
                    break;
                }
                this.removeDOMColumn(column);
            }
        }
    }

    @Override
    public void initialSyncUIWithDataModel() {
        TableModel dataModel = this.getTableModel();
        int columns = dataModel.getColumnCount();
        this.setDOMColumnCount(columns);
        int rows = dataModel.getRowCount();
        this.setDOMRowCount(rows);
        this.copyRowValuesFromDataModelToUI();
        if (this.header != null) {
            this.header.copyHeaderValuesFromDataModelToUI();
        }
    }

    public void syncRowsWithDataModel() {
        TableModel dataModel = this.getTableModel();
        int rows = dataModel.getRowCount();
        this.setDOMRowCount(rows);
        this.copyRowValuesFromDataModelToUI();
    }

    public void copyRowValuesFromDataModelToUI() {
        ItsNatTableUIImpl compUI = this.getItsNatTableUIImpl();
        TableModel dataModel = this.getTableModel();
        int rows = dataModel.getRowCount();
        int columns = dataModel.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                Object obj = dataModel.getValueAt(i, j);
                boolean isSelected = this.isCellSelected(i, j);
                compUI.setCellValueAt(i, j, obj, isSelected, false);
            }
        }
    }

    @Override
    public TableModel getTableModel() {
        return (TableModel)this.dataModel;
    }

    @Override
    public void setTableModel(TableModel dataModel) {
        this.setDataModel(dataModel);
    }

    public ListSelectionModelMgrImpl getRowSelectionModelMgr() {
        return this.rowSelModelMgr;
    }

    @Override
    public ListSelectionModel getRowSelectionModel() {
        if (this.rowSelModelMgr == null) {
            return null;
        }
        return this.rowSelModelMgr.getListSelectionModel();
    }

    public void unsetRowListSelectionModel() {
        if (this.rowSelModelMgr != null) {
            this.rowSelModelMgr.dispose();
        }
    }

    @Override
    public void setRowSelectionModel(ListSelectionModel rowSelectionModel) {
        this.unsetRowListSelectionModel();
        int size = this.getTableModel().getRowCount();
        this.rowSelModelMgr = ListSelectionModelMgrImpl.newListSelectionModelMgr(rowSelectionModel, size);
    }

    public ListSelectionModelMgrImpl getColumnSelectionModelMgr() {
        return this.columnSelModelMgr;
    }

    @Override
    public ListSelectionModel getColumnSelectionModel() {
        if (this.columnSelModelMgr == null) {
            return null;
        }
        return this.columnSelModelMgr.getListSelectionModel();
    }

    public void unsetColumnListSelectionModel() {
        if (this.columnSelModelMgr != null) {
            this.columnSelModelMgr.dispose();
        }
    }

    @Override
    public void setColumnSelectionModel(ListSelectionModel columnSelectionModel) {
        this.unsetColumnListSelectionModel();
        int size = this.getTableModel().getColumnCount();
        this.columnSelModelMgr = ListSelectionModelMgrImpl.newListSelectionModelMgr(columnSelectionModel, size);
    }

    @Override
    public void processNormalEvent(Event evt) {
        String type = evt.getType();
        if (type.equals("click") || type.equals("mouseup")) {
            ItsNatTableUI bodyUI;
            ItsNatTableCellUI cellInfo;
            Node nodeClicked = (Node)((Object)evt.getTarget());
            MouseEvent mouseEvt = (MouseEvent)evt;
            boolean toggle = !this.isSelectionUsesKeyboard() ? true : mouseEvt.getCtrlKey();
            boolean extend = mouseEvt.getShiftKey();
            ItsNatTableHeaderCellUI headerCellInfo = null;
            if (this.header != null && (headerCellInfo = this.header.processEvent(nodeClicked, toggle, extend)) != null && (this.isRowSelectionAllowed() || this.isColumnSelectionAllowed())) {
                int column = headerCellInfo.getIndex();
                this.changeColumnSelection(column, toggle, extend);
            }
            if (headerCellInfo == null && (this.isRowSelectionAllowed() || this.isColumnSelectionAllowed()) && (cellInfo = (bodyUI = this.getItsNatTableUI()).getItsNatTableCellUIFromNode(nodeClicked)) != null) {
                int row = cellInfo.getRowIndex();
                int column = cellInfo.getColumnIndex();
                this.changeSelection(row, column, toggle, extend);
            }
        }
        super.processNormalEvent(evt);
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        boolean selected = this.isCellSelected(rowIndex, columnIndex);
        this.columnSelModelMgr.changeSelectionModel(columnIndex, toggle, extend, selected);
        this.rowSelModelMgr.changeSelectionModel(rowIndex, toggle, extend, selected);
    }

    public void changeColumnSelection(int columnIndex, boolean toggle, boolean extend) {
        ListSelectionModel csm = this.getColumnSelectionModel();
        boolean selected = csm.isSelectedIndex(columnIndex);
        this.columnSelModelMgr.changeSelectionModel(columnIndex, toggle, extend, selected);
    }

    @Override
    public void clearSelection() {
        this.getRowSelectionModel().clearSelection();
        this.getColumnSelectionModel().clearSelection();
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.clearSelection();
        this.getRowSelectionModel().setSelectionMode(selectionMode);
        this.getColumnSelectionModel().setSelectionMode(selectionMode);
    }

    @Override
    public boolean isRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    @Override
    public void setRowSelectionAllowed(boolean rowSelectionAllowed) {
        this.rowSelectionAllowed = rowSelectionAllowed;
    }

    @Override
    public boolean isColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public void setColumnSelectionAllowed(boolean columnSelectionAllowed) {
        this.columnSelectionAllowed = columnSelectionAllowed;
    }

    @Override
    public boolean isCellSelectionEnabled() {
        return this.isRowSelectionAllowed() && this.isColumnSelectionAllowed();
    }

    @Override
    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        this.setRowSelectionAllowed(cellSelectionEnabled);
        this.setColumnSelectionAllowed(cellSelectionEnabled);
    }

    @Override
    public boolean isRowSelected(int row) {
        return this.getRowSelectionModel().isSelectedIndex(row);
    }

    @Override
    public boolean isColumnSelected(int column) {
        return this.getColumnSelectionModel().isSelectedIndex(column);
    }

    @Override
    public boolean isCellSelected(int row, int column) {
        if (!this.isRowSelectionAllowed() && !this.isColumnSelectionAllowed()) {
            return false;
        }
        return !(this.isRowSelectionAllowed() && !this.isRowSelected(row) || this.isColumnSelectionAllowed() && !this.isColumnSelected(column));
    }

    @Override
    public void setRowSelectionInterval(int index0, int index1) {
        this.getRowSelectionModel().setSelectionInterval(index0, index1);
    }

    @Override
    public void setColumnSelectionInterval(int index0, int index1) {
        this.getColumnSelectionModel().setSelectionInterval(index0, index1);
    }

    @Override
    public int[] getSelectedRows() {
        return this.rowSelModelMgr.getSelectedIndices();
    }

    @Override
    public void setSelectedRows(int[] indices) {
        this.rowSelModelMgr.setSelectedIndices(indices);
    }

    @Override
    public int[] getSelectedColumns() {
        return this.columnSelModelMgr.getSelectedIndices();
    }

    @Override
    public void setSelectedColumns(int[] indices) {
        this.columnSelModelMgr.setSelectedIndices(indices);
    }

    @Override
    public int getSelectedColumn() {
        return this.getColumnSelectionModel().getMinSelectionIndex();
    }

    @Override
    public int getSelectedRow() {
        return this.getRowSelectionModel().getMinSelectionIndex();
    }

    @Override
    public void selectAll() {
        int rows = this.getTableModel().getRowCount();
        int columns = this.getTableModel().getColumnCount();
        if (rows > 0 && columns > 0) {
            this.setRowSelectionInterval(0, rows - 1);
            this.setColumnSelectionInterval(0, columns - 1);
        }
    }

    public Object[] getRowValues(int row, int colCount) {
        TableModel dataModel = this.getTableModel();
        Object[] rowValues = new Object[colCount];
        for (int j = 0; j < colCount; ++j) {
            rowValues[j] = dataModel.getValueAt(row, j);
        }
        return rowValues;
    }

    public Object[] getColumnValues(int column) {
        TableModel dataModel = this.getTableModel();
        int rowCount = dataModel.getRowCount();
        Object[] colValues = new Object[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            colValues[i] = dataModel.getValueAt(i, column);
        }
        return colValues;
    }

    public boolean[] getRowSelectionList(int row, int colCount) {
        boolean[] rowSelList = new boolean[colCount];
        for (int j = 0; j < colCount; ++j) {
            rowSelList[j] = this.isCellSelected(row, j);
        }
        return rowSelList;
    }

    public boolean[] getColumnSelectionList(int column) {
        TableModel dataModel = this.getTableModel();
        int rowCount = dataModel.getRowCount();
        boolean[] colSelList = new boolean[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            colSelList[i] = this.isCellSelected(i, column);
        }
        return colSelList;
    }

    @Override
    public ItsNatTableCellRenderer getItsNatTableCellRenderer() {
        return this.renderer;
    }

    @Override
    public void setItsNatTableCellRenderer(ItsNatTableCellRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public ItsNatTableCellEditor getItsNatTableCellEditor() {
        TableCellEditorProcessor editorProcessor = this.getTableCellEditorProcessor();
        return editorProcessor.getItsNatTableCellEditor();
    }

    @Override
    public void setItsNatTableCellEditor(ItsNatTableCellEditor cellEditor) {
        this.editorProcessor.setItsNatTableCellEditor(cellEditor);
    }

    @Override
    public void startEditingAt(int row, int column) {
        this.getTableCellEditorProcessor().startEdition(row, column);
    }

    @Override
    public boolean isEditing() {
        return this.getTableCellEditorProcessor().isEditing();
    }

    @Override
    public int getEditingRow() {
        return this.getTableCellEditorProcessor().getRow();
    }

    @Override
    public int getEditingColumn() {
        return this.getTableCellEditorProcessor().getColumn();
    }

    @Override
    public String getEditorActivatorEvent() {
        return this.getTableCellEditorProcessor().getEditorActivatorEvent();
    }

    @Override
    public void setEditorActivatorEvent(String editorActivatorEvent) {
        this.getTableCellEditorProcessor().setEditorActivatorEvent(editorActivatorEvent);
    }

    @Override
    public boolean isEditingEnabled() {
        return this.getTableCellEditorProcessor().isEditingEnabled();
    }

    @Override
    public void setEditingEnabled(boolean value) {
        this.getTableCellEditorProcessor().setEditingEnabled(value);
    }

    @Override
    public ParamTransport[] getInternalParamTransports(String type, ClientDocumentImpl clientDoc) {
        return null;
    }

    @Override
    public ItsNatTableStructure getItsNatTableStructure() {
        return this.structure;
    }

    @Override
    public Object createDefaultStructure() {
        return this.getItsNatComponentManager().createDefaultItsNatTableStructure();
    }

    @Override
    public void setSelectionUsesKeyboard(boolean value) {
        this.selectionUsesKeyboard = value;
    }

    @Override
    public boolean isSelectionUsesKeyboard() {
        return this.selectionUsesKeyboard;
    }

    @Override
    public Element[] getContentElementList() {
        ItsNatTableUI compUI = this.getItsNatTableUI();
        int rowCount = compUI.getRowCount();
        int colCount = compUI.getColumnCount();
        int headColCount = 0;
        ItsNatTableHeaderImpl header = this.getItsNatTableHeaderImpl();
        if (header != null) {
            headColCount = colCount;
        }
        Element[] elemList = new Element[rowCount * colCount + headColCount];
        for (int i = 0; i < rowCount; ++i) {
            int firstCellInRow = i * colCount;
            for (int j = 0; j < colCount; ++j) {
                elemList[firstCellInRow + j] = compUI.getCellContentElementAt(i, j);
            }
        }
        if (header != null) {
            elemList = header.getContentElementList(elemList, headColCount);
        }
        return elemList;
    }

    public Element[] getContentElementListOfRow(int row) {
        ItsNatTableUI compUI = this.getItsNatTableUI();
        TableModel dataModel = this.getTableModel();
        int colCount = dataModel.getColumnCount();
        Element[] elemList = new Element[colCount];
        for (int i = 0; i < colCount; ++i) {
            elemList[i] = compUI.getCellContentElementAt(row, i);
        }
        return elemList;
    }

    public Element[] getContentElementListOfColumn(int column) {
        ItsNatTableUI compUI = this.getItsNatTableUI();
        TableModel dataModel = this.getTableModel();
        int rowCount = dataModel.getRowCount();
        Element[] elemList = new Element[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            elemList[i] = compUI.getCellContentElementAt(i, column);
        }
        return elemList;
    }

    public void addInternalEventListenerJoystickModeRow(int row) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        Element[] elemList = this.getContentElementListOfRow(row);
        ItsNatCompNormalEventListenersJoystickSharedImpl.addEventListenerJoystick(normalEventListeners, elemList);
    }

    public void removeInternalEventListenerJoystickModeRow(int row) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        Element[] elemList = this.getContentElementListOfRow(row);
        ItsNatCompNormalEventListenersJoystickSharedImpl.removeEventListenerJoystick(normalEventListeners, elemList);
    }

    public void addInternalEventListenerJoystickModeRow(ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners, int row) {
        Element[] elemList = this.getContentElementListOfRow(row);
        ItsNatCompNormalEventListenersJoystickSharedImpl.addEventListenerJoystick(normalEventListeners, elemList);
    }

    public void removeInternalEventListenerJoystickModeRow(ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners, int row) {
        Element[] elemList = this.getContentElementListOfRow(row);
        ItsNatCompNormalEventListenersJoystickSharedImpl.removeEventListenerJoystick(normalEventListeners, elemList);
    }

    public void addInternalEventListenerJoystickModeColumn(int column) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        Element[] elemList = this.getContentElementListOfColumn(column);
        ItsNatCompNormalEventListenersJoystickSharedImpl.addEventListenerJoystick(normalEventListeners, elemList);
    }

    public void removeInternalEventListenerJoystickModeColumn(int column) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        Element[] elemList = this.getContentElementListOfColumn(column);
        ItsNatCompNormalEventListenersJoystickSharedImpl.removeEventListenerJoystick(normalEventListeners, elemList);
    }

    public void addInternalEventListenerJoystickModeColumn(ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners, int column) {
        Element[] elemList = this.getContentElementListOfColumn(column);
        ItsNatCompNormalEventListenersJoystickSharedImpl.addEventListenerJoystick(normalEventListeners, elemList);
    }

    public void removeInternalEventListenerJoystickModeColumn(ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners, int column) {
        Element[] elemList = this.getContentElementListOfColumn(column);
        ItsNatCompNormalEventListenersJoystickSharedImpl.removeEventListenerJoystick(normalEventListeners, elemList);
    }

    public void addInternalEventListenerJoystickModeRowRange(int fromRow, int toRow) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        for (int i = fromRow; i <= toRow; ++i) {
            this.addInternalEventListenerJoystickModeRow(normalEventListeners, i);
        }
    }

    public void removeInternalEventListenerJoystickModeRowRange(int fromRow, int toRow) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        for (int i = fromRow; i <= toRow; ++i) {
            this.removeInternalEventListenerJoystickModeRow(normalEventListeners, i);
        }
    }

    public void addInternalEventListenerJoystickModeColumnRange(int fromColumn, int toColumn) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        for (int i = fromColumn; i <= toColumn; ++i) {
            this.addInternalEventListenerJoystickModeColumn(normalEventListeners, i);
        }
    }

    public void removeInternalEventListenerJoystickModeColumnRange(int fromColumn, int toColumn) {
        ArrayList<ItsNatCompNormalEventListenersJoystick> normalEventListeners = ItsNatCompNormalEventListenersJoystickSharedImpl.getMustAddRemove(this);
        if (normalEventListeners.isEmpty()) {
            return;
        }
        for (int i = fromColumn; i <= toColumn; ++i) {
            this.removeInternalEventListenerJoystickModeColumn(normalEventListeners, i);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }
}

