/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.listener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.itsnat.core.event.ParamTransport;
import org.itsnat.impl.comp.ItsNatComponentImpl;
import org.itsnat.impl.comp.listener.EventListenerParamsImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.event.ItsNatEventImpl;
import org.itsnat.impl.core.event.ItsNatEventListenerChainImpl;
import org.itsnat.impl.core.listener.EventListenerUtil;
import org.itsnat.impl.core.registry.ItsNatNormalEventListenerListSameTarget;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class ItsNatCompNormalEventListenersImpl
implements Serializable {
    protected ItsNatComponentImpl comp;
    protected ItsNatNormalEventListenerListSameTarget userNormalEventListenersBefore;
    protected ItsNatNormalEventListenerListSameTarget userNormalEventListenersAfter;
    protected Set<String> enabledNormalEvents;
    protected Map<String, EventListenerParamsImpl> evtListParams;

    public ItsNatCompNormalEventListenersImpl(ItsNatComponentImpl comp) {
        this.comp = comp;
    }

    public ItsNatComponentImpl getItsNatComponent() {
        return this.comp;
    }

    public ItsNatDocumentImpl getItsNatDocumentImpl() {
        return this.comp.getItsNatDocumentImpl();
    }

    public boolean hasEnabledNormalEvents() {
        if (this.enabledNormalEvents == null) {
            return false;
        }
        return !this.enabledNormalEvents.isEmpty();
    }

    public Set<String> getEnabledNormalEvents() {
        if (this.enabledNormalEvents == null) {
            this.enabledNormalEvents = new HashSet<String>();
        }
        return this.enabledNormalEvents;
    }

    public boolean hasUserNormalEventListeners(boolean before) {
        if (before) {
            return this.userNormalEventListenersBefore != null && !this.userNormalEventListenersBefore.isEmpty();
        }
        return this.userNormalEventListenersAfter != null && !this.userNormalEventListenersAfter.isEmpty();
    }

    public boolean hasUserNormalEventListeners(String type, boolean before) {
        if (!this.hasUserNormalEventListeners(before)) {
            return false;
        }
        return this.getUserNormalEventListeners(before).hasItsNatNormalEventListeners(type, false);
    }

    public ItsNatNormalEventListenerListSameTarget getUserNormalEventListeners(boolean before) {
        if (before) {
            if (this.userNormalEventListenersBefore == null) {
                this.userNormalEventListenersBefore = new ItsNatNormalEventListenerListSameTarget(this.getItsNatDocumentImpl());
            }
            return this.userNormalEventListenersBefore;
        }
        if (this.userNormalEventListenersAfter == null) {
            this.userNormalEventListenersAfter = new ItsNatNormalEventListenerListSameTarget(this.getItsNatDocumentImpl());
        }
        return this.userNormalEventListenersAfter;
    }

    public void processNormalEventUserListeners(Event evt, boolean before) {
        if (this.hasUserNormalEventListeners(before)) {
            ItsNatEventListenerChainImpl chain = ((ItsNatEventImpl)((Object)evt)).getItsNatEventListenerChainImpl();
            if (this.getUserNormalEventListeners(before).getItsNatNormalEventListenerList(evt.getType(), false, chain)) {
                EventListenerUtil.handleEventListeners(evt, chain);
            }
        }
    }

    public void addUserEventListener(String type, EventListener listener, boolean before) {
        this.enableEventListener(type);
        this.getUserNormalEventListeners(before).addItsNatNormalEventListener(type, false, listener);
    }

    public void removeUserEventListener(String type, EventListener listener, boolean before) {
        this.getUserNormalEventListeners(before).removeItsNatNormalEventListener(type, false, listener);
    }

    public void disableEventListeners(boolean updateClient) {
        if (this.hasEnabledNormalEvents()) {
            Object[] types = this.getEnabledNormalEvents().toArray();
            for (int i = 0; i < types.length; ++i) {
                String type = (String)types[i];
                this.disableEventListener(type, updateClient);
            }
        }
    }

    public void enableEventListener(String type) {
        Set<String> enabledNormalEvents = this.getEnabledNormalEvents();
        if (enabledNormalEvents.contains(type)) {
            return;
        }
        this.addInternalEventListener(type);
        enabledNormalEvents.add(type);
    }

    public void disableEventListener(String type) {
        this.disableEventListener(type, true);
    }

    public void disableEventListener(String type, boolean updateClient) {
        Set<String> enabledNormalEvents = this.getEnabledNormalEvents();
        if (!enabledNormalEvents.contains(type)) {
            return;
        }
        this.removeInternalEventListener(type, updateClient);
        enabledNormalEvents.remove(type);
    }

    public Map<String, EventListenerParamsImpl> getEventListenerParamMap() {
        if (this.evtListParams == null) {
            this.evtListParams = new HashMap<String, EventListenerParamsImpl>();
        }
        return this.evtListParams;
    }

    protected abstract void addInternalEventListener(String var1);

    protected abstract void removeInternalEventListener(String var1, boolean var2);

    public void addInternalEventListener(ClientDocumentImpl clientDoc, String type) {
        EventListenerParamsImpl params = this.getEventListenerParams(type);
        ParamTransport[] extraParams = this.getParamTransports(type, params, clientDoc);
        boolean useCapture = this.isUseCapture(params);
        int commMode = this.getCommModeDeclared(params);
        String preSendCode = this.getPreSendCode(params);
        long eventTimeout = this.getEventTimeout(params);
        String bindToCustomFunc = this.getBindToCustomFunc(params);
        this.addInternalEventListener(clientDoc, type, useCapture, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    protected void removeInternalEventListener(ClientDocumentImpl clientDoc, String type, boolean updateClient) {
        EventListenerParamsImpl params = this.getEventListenerParams(type);
        boolean useCapture = params != null ? params.isUseCapture() : false;
        this.removeInternalEventListener(clientDoc, type, useCapture, updateClient);
    }

    protected void addInternalEventListener(ClientDocumentImpl clientDoc, String type, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout, String bindToCustomFunc) {
        clientDoc.addEventListener((EventTarget)((Object)this.comp.getNode()), type, this.comp, useCapture, commMode, extraParams, preSendCode, eventTimeout, bindToCustomFunc);
    }

    protected void removeInternalEventListener(ClientDocumentImpl clientDoc, String type, boolean useCapture, boolean updateClient) {
        clientDoc.removeEventListener((EventTarget)((Object)this.comp.getNode()), type, this.comp, useCapture, updateClient);
    }

    public EventListenerParamsImpl getEventListenerParams(String type) {
        if (this.evtListParams == null) {
            return null;
        }
        return this.evtListParams.get(type);
    }

    public boolean isUseCapture(EventListenerParamsImpl params) {
        if (params == null) {
            return false;
        }
        return params.isUseCapture();
    }

    public int getCommModeDeclared(EventListenerParamsImpl params) {
        if (params == null) {
            return this.getItsNatDocumentImpl().getCommMode();
        }
        return params.getCommModeDeclared();
    }

    public String getPreSendCode(EventListenerParamsImpl params) {
        if (params == null) {
            return null;
        }
        return params.getPreSendCode();
    }

    public long getEventTimeout(EventListenerParamsImpl params) {
        if (params == null) {
            return this.getItsNatDocumentImpl().getEventTimeout();
        }
        return params.getEventTimeout();
    }

    public String getBindToCustomFunc(EventListenerParamsImpl params) {
        if (params == null) {
            return this.getItsNatDocumentImpl().getBindToCustomFunc();
        }
        return params.getBindToCustomFunc();
    }

    public ParamTransport[] getParamTransports(String type, EventListenerParamsImpl params, ClientDocumentImpl clientDoc) {
        ParamTransport[] extraParamsUser = null;
        if (params != null) {
            extraParamsUser = params.getExtraParams();
        }
        return this.getParamTransports(type, extraParamsUser, clientDoc);
    }

    private ParamTransport[] getParamTransports(String type, ParamTransport[] extraParamsUser, ClientDocumentImpl clientDoc) {
        ParamTransport[] extraParamsInt = this.comp.getInternalParamTransports(type, clientDoc);
        ParamTransport[] extraParamsFinal = null;
        if (extraParamsUser != null || extraParamsInt != null) {
            if (extraParamsUser == null) {
                extraParamsFinal = extraParamsInt;
            } else if (extraParamsInt == null) {
                extraParamsFinal = extraParamsUser;
            } else {
                ArrayList<ParamTransport> auxArray = new ArrayList<ParamTransport>();
                auxArray.addAll(Arrays.asList(extraParamsUser));
                auxArray.addAll(Arrays.asList(extraParamsInt));
                extraParamsFinal = auxArray.toArray(new ParamTransport[auxArray.size()]);
            }
        }
        return extraParamsFinal;
    }

    public void setEventListenerParams(String type, boolean useCapture, int commMode, ParamTransport[] extraParams, String preSendCode, long eventTimeout) {
        this.disableEventListener(type);
        EventListenerParamsImpl params = new EventListenerParamsImpl(useCapture, commMode, extraParams, preSendCode, eventTimeout, null);
        Map<String, EventListenerParamsImpl> evtListParams = this.getEventListenerParamMap();
        evtListParams.put(type, params);
        this.enableEventListener(type);
    }
}

