/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.list;

import java.io.Serializable;
import javax.swing.ListSelectionModel;
import org.itsnat.impl.comp.list.EmptyListSelectionModelImpl;

public class ListSelectionModelMgrImpl
implements Serializable {
    protected ListSelectionModel selectionModel;
    protected int size = 0;
    protected boolean disposed = false;

    public ListSelectionModelMgrImpl(ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            selectionModel = EmptyListSelectionModelImpl.SINGLETON;
        }
        this.selectionModel = selectionModel;
    }

    public static ListSelectionModelMgrImpl newListSelectionModelMgr(ListSelectionModel selectionModel, int size) {
        ListSelectionModelMgrImpl selModelMgr = new ListSelectionModelMgrImpl(selectionModel);
        selModelMgr.syncWithDataModel(size);
        return selModelMgr;
    }

    public void dispose() {
        this.disposed = true;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        int oldSize = this.size;
        int diff = size - oldSize;
        if (diff > 0) {
            this.insertElementUpdateModel(oldSize, diff);
        } else if (diff < 0) {
            diff = -diff;
            this.removeRangeUpdateModel(oldSize - diff, oldSize - 1);
        }
    }

    public ListSelectionModel getListSelectionModel() {
        return this.selectionModel;
    }

    public void syncWithDataModel(int size) {
        if (this.size > 0) {
            this.removeAllUpdateModel();
        }
        this.size = 0;
        this.insertElementUpdateModel(0, size);
        ListSelectionModel selectionModel = this.getListSelectionModel();
        selectionModel.clearSelection();
    }

    public void insertElementUpdateModel(int index) {
        this.insertElementUpdateModel(index, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElementUpdateModel(int index, int length) {
        if (length == 0) {
            return;
        }
        this.size += length;
        ListSelectionModel selectionModel = this.getListSelectionModel();
        boolean oldAdjusting = selectionModel.getValueIsAdjusting();
        selectionModel.setValueIsAdjusting(true);
        try {
            selectionModel.insertIndexInterval(index, length, true);
            if (selectionModel.isSelectedIndex(index)) {
                this.removeSelectionInterval(index, index + length - 1);
            }
        }
        finally {
            selectionModel.setValueIsAdjusting(false);
            selectionModel.setValueIsAdjusting(oldAdjusting);
        }
    }

    public void removeRangeUpdateModel(int fromIndex, int toIndex) {
        this.getListSelectionModel().removeIndexInterval(fromIndex, toIndex);
        this.size -= toIndex - fromIndex + 1;
        if (this.size == 0) {
            this.getListSelectionModel().clearSelection();
        }
    }

    public void removeAllUpdateModel() {
        int last = this.size - 1;
        if (last >= 0) {
            this.removeRangeUpdateModel(0, last);
        }
    }

    public void changeSelectionModel(int index, boolean toggle, boolean extend, boolean selected) {
        ListSelectionModel sm = this.getListSelectionModel();
        if (extend && toggle) {
            sm.setAnchorSelectionIndex(index);
        } else if (toggle) {
            if (selected) {
                this.removeSelectionInterval(index, index);
            } else {
                this.addSelectionInterval(index, index);
            }
        } else if (extend) {
            sm.setSelectionInterval(sm.getAnchorSelectionIndex(), index);
        } else {
            sm.setSelectionInterval(index, index);
        }
    }

    public int[] getSelectedIndices() {
        ListSelectionModel selModel = this.getListSelectionModel();
        int iMin = selModel.getMinSelectionIndex();
        int iMax = selModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] indices = new int[1 + (iMax - iMin)];
        int n = 0;
        for (int i = iMin; i <= iMax; ++i) {
            if (!selModel.isSelectedIndex(i)) continue;
            indices[n] = i;
            ++n;
        }
        int[] indicesFinal = new int[n];
        System.arraycopy(indices, 0, indicesFinal, 0, n);
        return indicesFinal;
    }

    public void addSelectionInterval(int first, int end) {
        ListSelectionModel selModel = this.getListSelectionModel();
        int mode = selModel.getSelectionMode();
        if (mode == 1) {
            int i = first - 1;
            while (i >= 0 && selModel.isSelectedIndex(i)) {
                first = i--;
            }
            int max = selModel.getMaxSelectionIndex();
            int i2 = end + 1;
            while (i2 <= max && selModel.isSelectedIndex(i2)) {
                end = i2++;
            }
        }
        selModel.addSelectionInterval(first, end);
    }

    public void removeSelectionInterval(int first, int end) {
        ListSelectionModel selModel = this.getListSelectionModel();
        selModel.removeSelectionInterval(first, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndices(int[] indices) {
        boolean[] newState = new boolean[this.size];
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            newState[index] = true;
        }
        ListSelectionModel selModel = this.getListSelectionModel();
        boolean[] changed = new boolean[this.size];
        for (int i = 0; i < this.size; ++i) {
            boolean selected = newState[i];
            changed[i] = selected != selModel.isSelectedIndex(i);
        }
        boolean oldAdjusting = selModel.getValueIsAdjusting();
        selModel.setValueIsAdjusting(true);
        boolean isSelectionInterval = false;
        int first = -1;
        int end = -1;
        try {
            for (int i = 0; i < this.size; ++i) {
                if (changed[i]) {
                    boolean selected = newState[i];
                    if (selected) {
                        if (first >= 0) {
                            if (isSelectionInterval) {
                                end = i;
                                continue;
                            }
                            this.removeSelectionInterval(first, end);
                            isSelectionInterval = true;
                            first = i;
                            end = i;
                            continue;
                        }
                        isSelectionInterval = true;
                        first = i;
                        end = i;
                        continue;
                    }
                    if (first >= 0) {
                        if (!isSelectionInterval) {
                            end = i;
                            continue;
                        }
                        this.addSelectionInterval(first, end);
                        isSelectionInterval = false;
                        first = i;
                        end = i;
                        continue;
                    }
                    isSelectionInterval = false;
                    first = i;
                    end = i;
                    continue;
                }
                if (first >= 0) {
                    if (isSelectionInterval) {
                        this.addSelectionInterval(first, end);
                    } else {
                        this.removeSelectionInterval(first, end);
                    }
                }
                first = -1;
                end = -1;
            }
            if (first >= 0) {
                if (isSelectionInterval) {
                    this.addSelectionInterval(first, end);
                } else {
                    this.removeSelectionInterval(first, end);
                }
            }
        }
        finally {
            selModel.setValueIsAdjusting(false);
            selModel.setValueIsAdjusting(oldAdjusting);
        }
    }
}

