/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.list;

import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.itsnat.comp.ItsNatComponent;
import org.itsnat.comp.list.ItsNatListCellEditor;
import org.itsnat.comp.list.ItsNatListCellUI;
import org.itsnat.comp.list.ItsNatListUI;
import org.itsnat.impl.comp.inplace.EditorProcessorBaseImpl;
import org.itsnat.impl.comp.list.ItsNatFreeListMultSelImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

public class ListCellEditorProcessor
extends EditorProcessorBaseImpl {
    protected ItsNatListCellUI cellInfo;

    public ListCellEditorProcessor(ItsNatFreeListMultSelImpl compParent) {
        super(compParent);
    }

    public ItsNatFreeListMultSelImpl getItsNatFreeListMultSel() {
        return (ItsNatFreeListMultSelImpl)this.compParent;
    }

    public ItsNatListCellEditor getItsNatListCellEditor() {
        return (ItsNatListCellEditor)this.cellEditor;
    }

    public void setItsNatListCellEditor(ItsNatListCellEditor cellEditor) {
        this.setCellEditor(cellEditor);
    }

    public void setCurrentContext(ItsNatListCellUI cellInfo) {
        this.cellInfo = cellInfo;
    }

    public int getIndex() {
        if (this.cellInfo == null) {
            return -1;
        }
        return this.cellInfo.getIndex();
    }

    public void startEdition(int index) {
        if (this.prepareEdition()) {
            this.openEditor(index);
        }
    }

    protected void openEditor(int index) {
        ItsNatListUI compUI = this.getItsNatFreeListMultSel().getItsNatListUI();
        ItsNatListCellUI cellInfo = compUI.getItsNatListCellUIAt(index);
        this.openEditor(cellInfo);
    }

    @Override
    protected void openEditor(Event evt) {
        Node nodeClicked = (Node)((Object)evt.getTarget());
        ItsNatListUI compUI = this.getItsNatFreeListMultSel().getItsNatListUI();
        ItsNatListCellUI cellInfo = compUI.getItsNatListCellUIFromNode(nodeClicked);
        this.openEditor(cellInfo);
    }

    private void openEditor(ItsNatListCellUI cellInfo) {
        if (cellInfo != null) {
            this.setCurrentContext(cellInfo);
            int index = cellInfo.getIndex();
            ItsNatFreeListMultSelImpl list = this.getItsNatFreeListMultSel();
            ListModel dataModel = list.getListModel();
            Element cellContentElem = cellInfo.getContentElement();
            Object value = dataModel.getElementAt(index);
            boolean isSelected = list.getListSelectionModel().isSelectedIndex(index);
            this.beforeShow(cellContentElem);
            ItsNatListCellEditor cellEditor = this.getItsNatListCellEditor();
            ItsNatComponent compEditor = cellEditor.getListCellEditorComponent(list, index, value, isSelected, cellContentElem);
            this.afterShow(compEditor);
        }
    }

    @Override
    public void acceptNewValue(Object value) {
        ListModel dataModel = this.getItsNatFreeListMultSel().getListModel();
        if (dataModel instanceof DefaultListModel) {
            int index = this.cellInfo.getIndex();
            ((DefaultListModel)dataModel).setElementAt(value, index);
        }
    }

    @Override
    public void clearCurrentContext() {
        this.setCurrentContext(null);
    }
}

