/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.list;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.comp.list.ItsNatComboBoxInternal;
import org.itsnat.impl.comp.list.ItsNatListSharedImpl;

public class ItsNatComboBoxSharedImpl
extends ItsNatListSharedImpl {
    public ItsNatComboBoxSharedImpl(ItsNatComboBoxInternal comp) {
        super(comp);
    }

    public ItsNatComboBoxInternal getItsNatComboBox() {
        return (ItsNatComboBoxInternal)this.comp;
    }

    public void syncWithDataModel() {
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        comp.setSelectedItemReminder(comp.getSelectedItem());
    }

    @Override
    public void initialSyncUIWithDataModel() {
        super.initialSyncUIWithDataModel();
        this.copyCurrentSelectionToUI();
    }

    public static void checkMutableComboBoxModel(ComboBoxModel model) {
        if (!(model instanceof MutableComboBoxModel)) {
            throw new ItsNatException("Expected a MutableComboBoxModel", (Object)model);
        }
    }

    public void removeAllElements() {
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        MutableComboBoxModel dataModel = (MutableComboBoxModel)comp.getComboBoxModel();
        if (dataModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)dataModel).removeAllElements();
        } else {
            while (dataModel.getSize() > 0) {
                Object element = dataModel.getElementAt(0);
                dataModel.removeElement(element);
            }
        }
    }

    public int getSelectedIndex() {
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        ComboBoxModel dataModel = comp.getComboBoxModel();
        Object selected = dataModel.getSelectedItem();
        return ItsNatComboBoxSharedImpl.indexOf(selected, dataModel);
    }

    public void setSelectedIndex(int index) {
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        ComboBoxModel dataModel = comp.getComboBoxModel();
        ItsNatComboBoxSharedImpl.setSelectedIndex(dataModel, index);
    }

    public static void setSelectedIndex(ComboBoxModel dataModel, int index) {
        Object selected = dataModel.getElementAt(index);
        dataModel.setSelectedItem(selected);
    }

    public Object getSelectedItem() {
        return this.getItsNatComboBox().getComboBoxModel().getSelectedItem();
    }

    public void setSelectedItem(Object anObject) {
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        comp.getComboBoxModel().setSelectedItem(anObject);
    }

    public Object[] getSelectedObjects() {
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        ComboBoxModel dataModel = comp.getComboBoxModel();
        Object selectedObject = dataModel.getSelectedItem();
        if (selectedObject == null) {
            return new Object[0];
        }
        return new Object[]{selectedObject};
    }

    public void fireItemStateChanged(ItemEvent e) {
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        if (comp.hasItemListeners()) {
            ItemListener[] listeners = comp.getItemListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].itemStateChanged(e);
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        super.contentsChanged(e);
        this.copyCurrentSelectionToUI();
        this.selectedItemChanged();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        super.intervalAdded(e);
        this.selectedItemChanged();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        super.intervalRemoved(e);
        this.selectedItemChanged();
    }

    public void copyCurrentSelectionToUI() {
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        ComboBoxModel dataModel = comp.getComboBoxModel();
        Object selectedObj = dataModel.getSelectedItem();
        int index = ItsNatComboBoxSharedImpl.indexOf(selectedObj, dataModel);
        comp.setUISelectedIndex(index);
    }

    public void selectedItemChanged() {
        Object newSelection;
        ItsNatComboBoxInternal comp = this.getItsNatComboBox();
        Object oldSelection = comp.getSelectedItemReminder();
        if (oldSelection == (newSelection = comp.getComboBoxModel().getSelectedItem())) {
            return;
        }
        if (oldSelection != null) {
            comp.fireItemStateChanged(new ItemEvent(comp, 701, oldSelection, 2));
        }
        comp.setSelectedItemReminder(newSelection);
        if (newSelection != null) {
            comp.fireItemStateChanged(new ItemEvent(comp, 701, newSelection, 1));
        }
    }
}

