/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.layer;

import org.itsnat.impl.comp.layer.ItsNatModalLayerClientDocImpl;
import org.itsnat.impl.comp.layer.ItsNatModalLayerSVGImpl;
import org.itsnat.impl.core.browser.web.BrowserAdobeSVG;
import org.itsnat.impl.core.browser.web.BrowserBatik;
import org.itsnat.impl.core.browser.web.BrowserGecko;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.browser.web.opera.BrowserOperaOld;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.domutil.NamespaceUtil;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderElementImpl;
import org.w3c.dom.Element;

public class ItsNatModalLayerClientDocSVGImpl
extends ItsNatModalLayerClientDocImpl {
    public ItsNatModalLayerClientDocSVGImpl(ItsNatModalLayerSVGImpl parentComp, ClientDocumentStfulDelegateWebImpl clientDoc) {
        super(parentComp, clientDoc);
    }

    @Override
    public void initModalLayer() {
        Element layerElem = this.parentComp.getElement();
        String background = this.parentComp.getBackground();
        float opacity = this.parentComp.getOpacity();
        StringBuilder code = new StringBuilder();
        String elemLayerRef = this.clientDoc.getNodeReference(layerElem, true, true);
        code.append("var elem = " + elemLayerRef + ";\n");
        code.append("elem.setAttribute('x','0');\n");
        code.append("elem.setAttribute('y','0');\n");
        code.append("elem.setAttribute('width','100%');\n");
        code.append("elem.setAttribute('height','100%');\n");
        StringBuilder styleCode = new StringBuilder();
        styleCode.append("fill-opacity:" + opacity + ";");
        if (background != null) {
            styleCode.append("fill:" + background + ";");
        }
        code.append("elem.setAttribute('style','" + styleCode.toString() + "');\n");
        if (this.clientDoc.getBrowserWeb() instanceof BrowserBatik) {
            code.append("var elemClone = elem.cloneNode(false);");
            code.append("elem.parentNode.replaceChild(elemClone,elem);");
            code.append("elemClone.parentNode.replaceChild(elem,elemClone);");
        }
        if (this.needsRedimension()) {
            String methodName = "initModalLayerSVG";
            if (!this.clientDoc.isClientMethodBounded(methodName)) {
                code.append(this.bindInitModalLayerMethod(methodName));
            }
            code.append("itsNatDoc." + methodName + "(elem);\n");
        }
        this.clientDoc.addCodeToSend(code.toString());
    }

    private String bindInitModalLayerMethod(String methodName) {
        StringBuilder code = new StringBuilder();
        code.append("var func = function (elem)\n");
        code.append("{\n");
        code.append("  var listener = function ()\n");
        code.append("  {\n");
        code.append("    var elem = arguments.callee.elem;\n");
        code.append("   elem.setAttribute('width','1px');\n");
        code.append("   elem.setAttribute('height','1px');\n");
        code.append("   elem.setAttribute('width','100%');\n");
        code.append("   elem.setAttribute('height','100%');\n");
        int timeout = this.getTimeout();
        if (timeout > 0) {
            code.append("    elem.itsNatModalLayerTimer = itsNatDoc.setTimeout(arguments.callee," + timeout + ");\n");
        }
        code.append("  };\n");
        code.append("  listener.elem = elem;\n");
        code.append("  listener();\n");
        code.append("};\n");
        code.append("itsNatDoc." + methodName + " = func;\n");
        this.clientDoc.bindClientMethod(methodName);
        return code.toString();
    }

    public boolean needsRedimension() {
        return this.getTimeout() > 0;
    }

    @Override
    public int getTimeout() {
        int timeout = super.getTimeout();
        if (timeout <= 0) {
            return -1;
        }
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        BrowserWeb browser = clientDoc.getBrowserWeb();
        if (browser instanceof BrowserGecko || browser instanceof BrowserOperaOld || browser instanceof BrowserAdobeSVG || browser instanceof BrowserBatik) {
            return -1;
        }
        return timeout;
    }

    @Override
    public void preRemoveLayer() {
        if (this.getTimeout() >= 0) {
            Element element = this.parentComp.getElement();
            String elemLayerRef = this.clientDoc.getNodeReference(element, true, true);
            this.clientDoc.addCodeToSend("itsNatDoc.clearTimeout(" + elemLayerRef + ".itsNatModalLayerTimer);");
        }
    }

    @Override
    protected void renderShowHide(Element elem, String elemVarName, boolean hide, StringBuilder code, JSRenderElementImpl render) {
        if (NamespaceUtil.isSVGElement(elem)) {
            String localName = elem.getLocalName();
            if (localName.equals("script")) {
                return;
            }
            ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
            BrowserWeb browser = clientDoc.getBrowserWeb();
            if (browser instanceof BrowserAdobeSVG && localName.equals("foreignObject")) {
                return;
            }
        }
        super.renderShowHide(elem, elemVarName, hide, code, render);
    }
}

