/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.layer;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.itsnat.impl.comp.layer.ItsNatModalLayerImpl;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.scriptren.jsren.node.JSRenderElementImpl;
import org.w3c.dom.Element;

public abstract class ItsNatModalLayerClientDocImpl
implements Serializable {
    protected ItsNatModalLayerImpl parentComp;
    protected ClientDocumentStfulDelegateWebImpl clientDoc;

    public ItsNatModalLayerClientDocImpl(ItsNatModalLayerImpl parentComp, ClientDocumentStfulDelegateWebImpl clientDoc) {
        this.parentComp = parentComp;
        this.clientDoc = clientDoc;
    }

    public ItsNatModalLayerImpl getItsNatModalLayer() {
        return this.parentComp;
    }

    public ClientDocumentStfulDelegateWebImpl getClientDocumentStfulDelegateWeb() {
        return this.clientDoc;
    }

    public void attachClientToComponent() {
        this.initModalLayer();
        this.showHideBodyElements(true);
    }

    public void postInsertLayer() {
        this.initModalLayer();
        this.showHideBodyElements(true);
    }

    public void postRemoveLayer() {
        this.showHideBodyElements(false);
    }

    public boolean isCleanBelowMode() {
        return this.parentComp.isCleanBelowMode();
    }

    protected void showHideBodyElements(boolean hide) {
        if (!this.isCleanBelowMode()) {
            return;
        }
        LinkedHashSet<Element> bodyElementsBefore = this.getItsNatModalLayer().getBodyElementsBefore();
        Element[] reverseBodyElements = new Element[bodyElementsBefore.size()];
        if (hide) {
            int i = reverseBodyElements.length - 1;
            Iterator it = bodyElementsBefore.iterator();
            while (it.hasNext()) {
                Element elem;
                reverseBodyElements[i] = elem = (Element)it.next();
                --i;
            }
        } else {
            reverseBodyElements = bodyElementsBefore.toArray(reverseBodyElements);
        }
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        StringBuilder code = new StringBuilder();
        for (int i = 0; i < reverseBodyElements.length; ++i) {
            Element elem = reverseBodyElements[i];
            JSRenderElementImpl render = JSRenderElementImpl.getJSRenderElement(elem, clientDoc);
            String elemRef = clientDoc.getNodeReference(elem, true, true);
            code.append("var elem = " + elemRef + ";\n");
            this.renderShowHide(elem, "elem", hide, code, render);
        }
        clientDoc.addCodeToSend(code.toString());
    }

    protected void renderShowHide(Element elem, String elemVarName, boolean hide, StringBuilder code, JSRenderElementImpl render) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        if (hide) {
            code.append(render.getBackupAndSetStyleProperty(elemVarName, "display", "none", clientDoc));
        } else {
            code.append(render.getRestoreBackupStyleProperty(elemVarName, "display", clientDoc));
        }
    }

    public int getTimeout() {
        BrowserWeb browser = this.clientDoc.getBrowserWeb();
        if (browser.isMobile()) {
            return 1000;
        }
        return 500;
    }

    public abstract void preRemoveLayer();

    public abstract void initModalLayer();
}

