/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.layer;

import org.itsnat.impl.comp.layer.ItsNatModalLayerClientDocImpl;
import org.itsnat.impl.comp.layer.ItsNatModalLayerHTMLImpl;
import org.itsnat.impl.core.browser.web.BrowserMSIE9Up;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.browser.web.opera.BrowserOperaOld;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.w3c.dom.Element;

public abstract class ItsNatModalLayerClientDocHTMLImpl
extends ItsNatModalLayerClientDocImpl {
    public ItsNatModalLayerClientDocHTMLImpl(ItsNatModalLayerHTMLImpl comp, ClientDocumentStfulDelegateWebImpl clientDoc) {
        super(comp, clientDoc);
    }

    public ItsNatModalLayerHTMLImpl getItsNatModalLayerHTML() {
        return (ItsNatModalLayerHTMLImpl)this.parentComp;
    }

    @Override
    public void initModalLayer() {
        String backgroundProp;
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        BrowserWeb browser = clientDoc.getBrowserWeb();
        Element layerElem = this.parentComp.getElement();
        int zIndex = this.parentComp.getZIndex();
        String background = this.parentComp.getBackground();
        float opacity = this.parentComp.getOpacity();
        if (background != null && opacity >= 0.5f) {
            backgroundProp = background;
        } else if (background == null) {
            if (browser instanceof BrowserMSIEOld || browser instanceof BrowserMSIE9Up && ((BrowserMSIE9Up)browser).getVersion() == 9) {
                backgroundProp = "white";
                opacity = 0.0f;
            } else {
                backgroundProp = null;
            }
        } else {
            backgroundProp = background;
        }
        StringBuilder code = new StringBuilder();
        String elemLayerRef = clientDoc.getNodeReference(layerElem, true, true);
        code.append("var elem = " + elemLayerRef + ";\n");
        StringBuilder styleCode = new StringBuilder();
        styleCode.append("position:absolute; top:0px; left:0px; width:100%; height:100%; margin:0px; padding:0px; border:0px; ");
        styleCode.append("z-index:" + zIndex + "; ");
        styleCode.append("opacity:" + opacity + "; ");
        if (browser instanceof BrowserMSIEOld) {
            int opInt = (int)(100.0f * opacity);
            styleCode.append("filter:alpha(opacity=" + opInt + "); ");
        }
        if (backgroundProp != null) {
            styleCode.append("background:" + backgroundProp + "; ");
        } else if (browser instanceof BrowserOperaOld) {
            styleCode.append("background-image:url('data:image/gif;base64,R0lGODlhCgAKAIAAAP///////yH5BAEKAAEALAAAAAAKAAoAAAIIjI+py+0PYysAOw==');");
        }
        code.append("itsNatDoc.setAttribute(elem,\"style\",\"" + styleCode.toString() + "\");\n");
        String methodName = "initModalLayerHTML";
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(this.bindInitModalLayerMethod(methodName));
        }
        code.append("itsNatDoc." + methodName + "(elem);\n");
        clientDoc.addCodeToSend(code.toString());
    }

    protected String bindInitModalLayerMethod(String methodName) {
        BrowserWeb browser = this.clientDoc.getBrowserWeb();
        StringBuilder code = new StringBuilder();
        code.append("var func = function (elem)\n");
        code.append("{\n");
        code.append("  var listener = function ()\n");
        code.append("  {\n");
        code.append("    var elem = arguments.callee.elem;\n");
        code.append("    var maxW = 1;\n");
        code.append("    var maxH = 1;\n");
        code.append("    var style = elem.style;\n");
        code.append("    while(true)\n");
        code.append("    {\n");
        code.append("      var currW = elem.scrollWidth;\n");
        code.append("      var currH = elem.scrollHeight;\n");
        code.append("      currW = parseInt((currW*49)/50);\n");
        code.append("      currH = parseInt((currH*49)/50);\n");
        code.append("      style.width =  currW + 'px';\n");
        code.append("      style.height = currH + 'px';\n");
        if (browser instanceof BrowserMSIEOld || browser instanceof BrowserWebKit) {
            code.append("      var top1 = itsNatDoc.doc.documentElement;\n");
            code.append("      var top2 = itsNatDoc.getVisualRootElement();\n");
            code.append("      maxW = Math.max(top1.scrollWidth,top2.scrollWidth);\n");
            code.append("      maxH = Math.max(top1.scrollHeight,top2.scrollHeight);\n");
        } else {
            code.append("      var top = itsNatDoc.doc.documentElement;\n");
            code.append("      maxW = top.scrollWidth;\n");
            code.append("      maxH = top.scrollHeight;\n");
        }
        code.append("      if ((currW<maxW)&&(currH<maxH)) break; \n");
        code.append("    }\n");
        code.append("    style.width  = maxW + 'px';\n");
        code.append("    style.height = maxH + 'px';\n");
        int timeout = this.getTimeout();
        if (timeout > 0) {
            code.append("    elem.itsNatModalLayerTimer = itsNatDoc.setTimeout(arguments.callee," + timeout + ");\n");
        }
        code.append("  };\n");
        code.append("  listener.elem = elem;\n");
        code.append("  listener();\n");
        code.append("};\n");
        code.append("itsNatDoc." + methodName + " = func;\n");
        this.clientDoc.bindClientMethod(methodName);
        return code.toString();
    }

    @Override
    public void preRemoveLayer() {
        if (this.getTimeout() > 0) {
            Element element = this.parentComp.getElement();
            String elemLayerRef = this.clientDoc.getNodeReference(element, true, true);
            this.clientDoc.addCodeToSend("itsNatDoc.clearTimeout(" + elemLayerRef + ".itsNatModalLayerTimer);");
        }
    }
}

