/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.layer;

import java.util.LinkedList;
import java.util.Map;
import org.itsnat.impl.comp.layer.ItsNatModalLayerClientDocHTMLImpl;
import org.itsnat.impl.comp.layer.ItsNatModalLayerHTMLImpl;
import org.itsnat.impl.comp.layer.ItsNatModalLayerImpl;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLInputElement;

public class ItsNatModalLayerClientDocHTMLHideFormElemImpl
extends ItsNatModalLayerClientDocHTMLImpl {
    public ItsNatModalLayerClientDocHTMLHideFormElemImpl(ItsNatModalLayerHTMLImpl comp, ClientDocumentStfulDelegateWebImpl clientDoc) {
        super(comp, clientDoc);
    }

    @Override
    public void initModalLayer() {
        this.showHideHTMLFormElements(false);
        super.initModalLayer();
    }

    @Override
    public void postRemoveLayer() {
        super.postRemoveLayer();
        this.showHideHTMLFormElements(true);
    }

    private void showHideHTMLFormElements(boolean show) {
        ClientDocumentStfulDelegateWebImpl clientDoc = this.getClientDocumentStfulDelegateWeb();
        ItsNatModalLayerHTMLImpl parentComp = this.getItsNatModalLayerHTML();
        ItsNatModalLayerImpl prevComp = parentComp.getPreviousItsNatModalLayer();
        int zIndex1 = prevComp != null ? prevComp.getZIndex() : Integer.MIN_VALUE;
        int zIndex2 = parentComp.getZIndex();
        StringBuilder code = new StringBuilder();
        String methodName = "modalLayerShowHTMLFormCtrls";
        if (!clientDoc.isClientMethodBounded(methodName)) {
            code.append(ItsNatModalLayerClientDocHTMLHideFormElemImpl.bindModalLayerShowFormCtrlsMethod(methodName, clientDoc));
        }
        BrowserWeb browser = clientDoc.getBrowserWeb();
        Map<String, String[]> localNames = browser.getHTMLFormControlsIgnoreZIndex();
        Document doc = clientDoc.getItsNatStfulDocument().getDocument();
        for (Map.Entry<String, String[]> entry : localNames.entrySet()) {
            String localName = entry.getKey();
            String[] types = entry.getValue();
            LinkedList<Node> elemList = DOMUtilInternal.getChildElementListWithTagNameNS(doc, "http://www.w3.org/1999/xhtml", localName, true);
            if (elemList == null) continue;
            for (Node node : elemList) {
                Element elem = (Element)node;
                if (types != null && elem instanceof HTMLInputElement) {
                    boolean found = false;
                    String type = elem.getAttribute("type");
                    if (type.equals("")) {
                        type = "text";
                    }
                    for (int i = 0; i < types.length; ++i) {
                        if (!types[i].equals(type)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                code.append("var elem = " + clientDoc.getNodeReference(elem, true, true) + ";\n");
                code.append("itsNatDoc." + methodName + "(elem," + show + "," + zIndex1 + "," + zIndex2 + ");\n");
            }
        }
        clientDoc.addCodeToSend(code);
    }

    private static String bindModalLayerShowFormCtrlsMethod(String methodName, ClientDocumentStfulDelegateWebImpl clientDoc) {
        BrowserWeb browser = clientDoc.getBrowserWeb();
        JSRenderHTMLElementImpl render = JSRenderHTMLElementImpl.getJSRenderHTMLElement(browser);
        StringBuilder code = new StringBuilder();
        code.append(render.bindBackupAndSetStylePropertyMethod(clientDoc));
        code.append(render.bindRestoreBackupStylePropertyMethod(clientDoc));
        code.append("var func = function (elem,show,zIndex1,zIndex2)");
        code.append("{");
        code.append("  var zIndex=0,zIndexMax=0;");
        code.append("  var parentNode = elem;");
        code.append("  while(parentNode.nodeType == 1)");
        code.append("  {");
        code.append("    var style = " + render.getCurrentStyleObject("this", "parentNode", clientDoc) + ";");
        code.append("    zIndex = style.zIndex;");
        code.append("    zIndex = parseInt(zIndex);");
        code.append("    if (isNaN(zIndex)) zIndex = 0;");
        code.append("    if (zIndex > zIndexMax) zIndexMax = zIndex;");
        code.append("    parentNode = parentNode.parentNode;");
        code.append("  }");
        code.append("  if ((zIndexMax < zIndex1)||(zIndexMax >= zIndex2)) return;");
        code.append("  if (show)");
        code.append("  {");
        code.append("    " + render.getRestoreBackupStyleProperty("elem", "visibility", clientDoc));
        code.append("  }");
        code.append("  else");
        code.append("  {");
        code.append("    " + render.getBackupAndSetStyleProperty("elem", "visibility", "hidden", clientDoc));
        code.append("  }");
        code.append("};");
        code.append("itsNatDoc." + methodName + " = func;\n");
        clientDoc.bindClientMethod(methodName);
        return code.toString();
    }
}

