/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.inplace;

import javax.swing.AbstractCellEditor;
import org.itsnat.comp.ItsNatComponent;
import org.itsnat.core.event.ItsNatEvent;
import org.itsnat.impl.comp.inplace.DelegateComponentEditorImpl;
import org.itsnat.impl.comp.inplace.ItsNatCellEditorClientImpl;
import org.itsnat.impl.comp.mgr.ItsNatStfulDocComponentManagerImpl;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.listener.EventListenerSerializableInternal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public abstract class ItsNatCellEditorImpl
extends AbstractCellEditor
implements EventListenerSerializableInternal {
    protected DelegateComponentEditorImpl delegate;
    protected ItsNatStfulDocComponentManagerImpl componentMgr;
    protected EventListener globalEventListener;
    protected boolean editing = false;

    public ItsNatCellEditorImpl(ItsNatComponent compEditor, ItsNatStfulDocComponentManagerImpl componentMgr) {
        this.componentMgr = componentMgr;
        this.delegate = DelegateComponentEditorImpl.createDelegateComponentEditor(compEditor, this);
        this.globalEventListener = new EventListenerSerializableInternal(){

            @Override
            public void handleEvent(Event evt) {
                ClientDocumentStfulImpl clientDoc = (ClientDocumentStfulImpl)((ItsNatEvent)((Object)evt)).getClientDocument();
                ItsNatCellEditorClientImpl editClient = ItsNatCellEditorClientImpl.getItsNatHTMLCellEditorClient(clientDoc.getBrowser(), ItsNatCellEditorImpl.this.getCellEditorComponent());
                editClient.handleGlobalEvent(evt, ItsNatCellEditorImpl.this);
            }
        };
    }

    public DelegateComponentEditorImpl getEditorDelegate() {
        return this.delegate;
    }

    public ItsNatDocumentImpl getItsNatDocument() {
        return this.componentMgr.getItsNatDocumentImpl();
    }

    public ItsNatStfulDocComponentManagerImpl getItsNatStfulDocComponentManager() {
        return this.componentMgr;
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public ItsNatComponent getCellEditorComponent() {
        return this.delegate.getCellEditorComponent();
    }

    public Element getCellElement() {
        ItsNatComponent compEditor = this.getCellEditorComponent();
        return (Element)compEditor.getNode().getParentNode();
    }

    public ItsNatComponent getCellEditorComponent(Object value, Element cellElem) {
        this.unregisterEventListeners();
        ItsNatComponent compEditor = this.getCellEditorComponent();
        Node nodeEditor = compEditor.getNode();
        this.delegate.preSetValue(value);
        cellElem.appendChild(nodeEditor);
        this.delegate.setValue(value);
        this.delegate.setFocus();
        this.registerEventListeners();
        return compEditor;
    }

    @Override
    public void handleEvent(Event evt) {
        String type = evt.getType();
        if (type.equals("blur")) {
            this.stopCellEditing();
        } else {
            ItsNatComponent compEditor = this.getCellEditorComponent();
            ItsNatStfulDocumentImpl itsNatDoc = (ItsNatStfulDocumentImpl)this.getItsNatDocument();
            ClientDocumentStfulImpl[] clientList = itsNatDoc.getAllClientDocumentStfulsCopy();
            for (int i = 0; i < clientList.length; ++i) {
                ClientDocumentStfulImpl clientDoc = clientList[i];
                ItsNatCellEditorClientImpl editClient = ItsNatCellEditorClientImpl.getItsNatHTMLCellEditorClient(clientDoc.getBrowser(), compEditor);
                editClient.handleEvent(evt, this, clientDoc);
            }
        }
    }

    @Override
    public boolean stopCellEditing() {
        this.unregisterEventListeners();
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.unregisterEventListeners();
        super.cancelCellEditing();
    }

    private void registerEventListeners() {
        this.editing = true;
        ItsNatComponent compEditor = this.getCellEditorComponent();
        compEditor.addEventListener("blur", this);
        ItsNatStfulDocumentImpl itsNatDoc = (ItsNatStfulDocumentImpl)this.getItsNatDocument();
        ClientDocumentStfulImpl[] clientList = itsNatDoc.getAllClientDocumentStfulsCopy();
        for (int i = 0; i < clientList.length; ++i) {
            ClientDocumentStfulImpl clientDoc = clientList[i];
            if (!(clientDoc.getClientDocumentStfulDelegate() instanceof ClientDocumentStfulDelegateWebImpl)) continue;
            ClientDocumentStfulDelegateWebImpl clientDocDeleg = (ClientDocumentStfulDelegateWebImpl)clientDoc.getClientDocumentStfulDelegate();
            ItsNatCellEditorClientImpl editClient = ItsNatCellEditorClientImpl.getItsNatHTMLCellEditorClient(clientDoc.getBrowser(), compEditor);
            editClient.registerEventListeners(this, clientDocDeleg);
        }
        itsNatDoc.addEventListener(0, this.globalEventListener);
    }

    private void unregisterEventListeners() {
        if (!this.editing) {
            return;
        }
        this.editing = false;
        ItsNatComponent compEditor = this.getCellEditorComponent();
        compEditor.removeEventListener("blur", this);
        ItsNatStfulDocumentImpl itsNatDoc = (ItsNatStfulDocumentImpl)this.getItsNatDocument();
        ClientDocumentStfulImpl[] clientList = itsNatDoc.getAllClientDocumentStfulsCopy();
        for (int i = 0; i < clientList.length; ++i) {
            ClientDocumentStfulImpl clientDoc = clientList[i];
            ItsNatCellEditorClientImpl editClient = ItsNatCellEditorClientImpl.getItsNatHTMLCellEditorClient(clientDoc.getBrowser(), compEditor);
            editClient.unregisterEventListeners(this, clientDoc);
        }
        itsNatDoc.removeEventListener(this.globalEventListener);
    }
}

