/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.inplace;

import org.itsnat.comp.ItsNatComponent;
import org.itsnat.core.event.ItsNatDOMStdEvent;
import org.itsnat.impl.comp.inplace.ItsNatCellEditorClientDefaultImpl;
import org.itsnat.impl.comp.inplace.ItsNatCellEditorImpl;
import org.itsnat.impl.comp.inplace.ItsNatHTMLCellEditorClientOperaOldMiniImpl;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.browser.web.opera.BrowserOperaOldMini;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKitIOS;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.scriptren.jsren.JSRenderMethodCallImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLElement;

public abstract class ItsNatCellEditorClientImpl {
    public static ItsNatCellEditorClientImpl getItsNatHTMLCellEditorClient(Browser browser, ItsNatComponent compEditor) {
        if (compEditor.getNode() instanceof HTMLElement) {
            if (browser instanceof BrowserOperaOldMini) {
                return ItsNatHTMLCellEditorClientOperaOldMiniImpl.SINGLETON;
            }
            return ItsNatCellEditorClientDefaultImpl.SINGLETON;
        }
        return ItsNatCellEditorClientDefaultImpl.SINGLETON;
    }

    public void handleGlobalEvent(Event evt, ItsNatCellEditorImpl parent) {
        if (evt instanceof ItsNatDOMStdEvent) {
            ItsNatComponent compEditor = parent.getCellEditorComponent();
            Node nodeEditor = compEditor.getNode();
            EventTarget target = evt.getTarget();
            if (target == nodeEditor) {
                return;
            }
            parent.stopCellEditing();
        }
    }

    public void handleEvent(Event evt, ItsNatCellEditorImpl parent, ClientDocumentStfulImpl clientDoc) {
    }

    public void registerEventListeners(ItsNatCellEditorImpl compParent, ClientDocumentStfulDelegateWebImpl clientDocDeleg) {
        ItsNatComponent compEditor = compParent.getCellEditorComponent();
        BrowserWeb browser = clientDocDeleg.getBrowserWeb();
        ClientDocumentStfulImpl clientDoc = clientDocDeleg.getClientDocumentStful();
        ItsNatStfulDocumentImpl itsNatDoc = (ItsNatStfulDocumentImpl)clientDoc.getItsNatDocument();
        Document doc = itsNatDoc.getDocument();
        Element nodeEditor = (Element)compEditor.getNode();
        StringBuilder codeListener = new StringBuilder();
        codeListener.append("event.setMustBeSent(false);\n");
        codeListener.append("try{");
        codeListener.append("var node = arguments.callee.nodeEditor;\n");
        codeListener.append("var target = event.getTarget();\n");
        codeListener.append("if (node == target) return;\n");
        JSRenderMethodCallImpl render = JSRenderMethodCallImpl.getJSRenderMethodCall(nodeEditor);
        codeListener.append(render.getCallBlurFocusFormControlCode(nodeEditor, "node", "blur", clientDocDeleg));
        codeListener.append("}catch(e){}\n");
        String bindToCustomFunc = "nodeEditor = " + clientDocDeleg.getNodeReference(nodeEditor, true, true);
        clientDoc.addEventListener((EventTarget)((Object)doc), "click", compParent, true, clientDoc.getCommMode(), null, codeListener.toString(), clientDoc.getEventTimeout(), bindToCustomFunc);
        if (browser instanceof BrowserWebKitIOS) {
            clientDoc.addEventListener((EventTarget)((Object)doc), "touchend", compParent, true, clientDoc.getCommMode(), null, codeListener.toString(), clientDoc.getEventTimeout(), bindToCustomFunc);
        }
    }

    public void unregisterEventListeners(ItsNatCellEditorImpl parent, ClientDocumentStfulImpl clientDoc) {
        Browser browser = clientDoc.getBrowser();
        ItsNatStfulDocumentImpl itsNatDoc = (ItsNatStfulDocumentImpl)clientDoc.getItsNatDocument();
        Document doc = itsNatDoc.getDocument();
        clientDoc.removeEventListener((EventTarget)((Object)doc), "click", parent, true);
        if (browser instanceof BrowserWebKitIOS) {
            clientDoc.removeEventListener((EventTarget)((Object)doc), "touchend", parent, true);
        }
    }
}

