/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.inplace;

import java.util.EventObject;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.itsnat.comp.ItsNatComponent;
import org.itsnat.impl.comp.ItsNatElementComponentImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.listener.EventListenerSerializableInternal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

public abstract class EditorProcessorBaseImpl
implements CellEditorListener,
EventListenerSerializableInternal {
    protected CellEditor cellEditor;
    protected Element cellElem;
    protected Node children;
    protected ItsNatElementComponentImpl compParent;
    protected String editorActivatorEvent = "dblclick";
    protected boolean editing = false;
    protected boolean registeredActivatorEvent = false;
    protected boolean editingEnabled = true;
    protected ItsNatComponent compEditor;

    public EditorProcessorBaseImpl(ItsNatElementComponentImpl compParent) {
        this.compParent = compParent;
    }

    public void dispose() {
        this.setCellEditor(null);
    }

    public CellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(CellEditor cellEditor) {
        if (this.cellEditor != null) {
            this.cellEditor.removeCellEditorListener(this);
            this.cellEditor = null;
        }
        this.cellEditor = cellEditor;
        if (cellEditor != null) {
            this.registerActivatorEvent();
            cellEditor.addCellEditorListener(this);
        } else {
            this.unregisterActivatorEvent();
        }
    }

    public void registerActivatorEvent() {
        if (this.registeredActivatorEvent || this.cellEditor == null) {
            return;
        }
        String type = this.getEditorActivatorEvent();
        if (type != null) {
            this.compParent.addEventListener(type, this);
            this.registeredActivatorEvent = true;
        }
    }

    public void unregisterActivatorEvent() {
        if (!this.registeredActivatorEvent) {
            return;
        }
        String type = this.getEditorActivatorEvent();
        if (type != null) {
            this.compParent.removeEventListener(type, this);
            this.registeredActivatorEvent = false;
        }
    }

    public void enableEventListenersByDoc() {
        this.registerActivatorEvent();
    }

    public void disableEventListeners(boolean updateClient) {
        this.unregisterActivatorEvent();
    }

    @Override
    public void handleEvent(Event evt) {
        this.startEdition(evt);
    }

    public String getEditorActivatorEvent() {
        return this.editorActivatorEvent;
    }

    public void setEditorActivatorEvent(String editorActivatorEvent) {
        this.finalizeEdition(false);
        this.unregisterActivatorEvent();
        this.editorActivatorEvent = editorActivatorEvent;
        this.registerActivatorEvent();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.finalizeEdition(true);
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.finalizeEdition(false);
    }

    public boolean isEditing() {
        return this.editing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeEdition(boolean acceptNewValue) {
        if (!this.isEditing()) {
            return;
        }
        String type = this.getEditorActivatorEvent();
        if (type != null) {
            this.compParent.enableEventListener(type);
        }
        this.registerActivatorEvent();
        DOMUtilInternal.removeAllChildren(this.cellElem);
        if (this.children != null) {
            this.cellElem.appendChild(this.children);
        }
        if (acceptNewValue) {
            CellEditor cellEditor = this.getCellEditor();
            Object value = cellEditor.getCellEditorValue();
            try {
                this.acceptNewValue(value);
            }
            finally {
                this.clearCurrentContext();
            }
        } else {
            this.clearCurrentContext();
        }
        this.children = null;
        this.cellElem = null;
        this.compEditor = null;
        this.editing = false;
    }

    public abstract void acceptNewValue(Object var1);

    public abstract void clearCurrentContext();

    public void startEdition(Event evt) {
        if (this.prepareEdition(evt)) {
            this.openEditor(evt);
        }
    }

    public boolean prepareEdition(Event evt) {
        if (!this.prepareEdition()) {
            return false;
        }
        return this.getCellEditor().isCellEditable((EventObject)((Object)evt));
    }

    public boolean prepareEdition() {
        if (!this.isEditingEnabled()) {
            return false;
        }
        this.finalizeEdition(false);
        CellEditor cellEditor = this.getCellEditor();
        return cellEditor != null;
    }

    public boolean isEditingEnabled() {
        return this.editingEnabled;
    }

    public void setEditingEnabled(boolean editingEnabled) {
        this.editingEnabled = editingEnabled;
    }

    public boolean isEditable() {
        return this.getCellEditor() != null;
    }

    public void beforeShow(Element cellElem) {
        this.cellElem = cellElem;
        this.children = DOMUtilInternal.extractChildren(cellElem);
    }

    public void afterShow(ItsNatComponent compEditor) {
        this.unregisterActivatorEvent();
        String type = this.getEditorActivatorEvent();
        if (type != null) {
            this.compParent.disableEventListener(type);
        }
        this.compEditor = compEditor;
        this.editing = true;
    }

    protected abstract void openEditor(Event var1);
}

