/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.inplace;

import java.beans.PropertyVetoException;
import org.itsnat.comp.text.ItsNatHTMLInputText;
import org.itsnat.comp.text.ItsNatHTMLInputTextFormatted;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.comp.inplace.DelegateHTMLElementComponentEditorImpl;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.w3c.dom.html.HTMLInputElement;

public class DelegateHTMLInputTextEditorImpl
extends DelegateHTMLElementComponentEditorImpl {
    public DelegateHTMLInputTextEditorImpl(ItsNatHTMLInputText compEditor) {
        super(compEditor);
    }

    public ItsNatHTMLInputText getItsNatHTMLInputText() {
        return (ItsNatHTMLInputText)this.compEditor;
    }

    @Override
    public Object getCellEditorValue() {
        ItsNatHTMLInputText compEditor = this.getItsNatHTMLInputText();
        if (compEditor instanceof ItsNatHTMLInputTextFormatted) {
            return ((ItsNatHTMLInputTextFormatted)compEditor).getValue();
        }
        return compEditor.getText();
    }

    @Override
    public void preSetValue(Object value) {
        String text = value.toString();
        ItsNatHTMLInputText compEditor = this.getItsNatHTMLInputText();
        HTMLInputElement inputElem = compEditor.getHTMLInputElement();
        int size = text.length();
        if (size <= 3) {
            size += 4 - size;
        }
        DOMUtilInternal.setAttribute(inputElem, "size", String.valueOf(size));
    }

    @Override
    public void setValue(Object value) {
        String text = value.toString();
        ItsNatHTMLInputText compEditor = this.getItsNatHTMLInputText();
        if (compEditor instanceof ItsNatHTMLInputTextFormatted) {
            try {
                ((ItsNatHTMLInputTextFormatted)compEditor).setValue(value);
            }
            catch (PropertyVetoException ex) {
                throw new ItsNatException(ex, (Object)compEditor);
            }
        } else {
            compEditor.setText(text);
        }
    }
}

