/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.inplace;

import java.io.Serializable;
import org.itsnat.comp.ItsNatComponent;
import org.itsnat.comp.ItsNatHTMLElementComponent;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.comp.inplace.DelegateHTMLElementComponentEditorImpl;
import org.itsnat.impl.comp.inplace.DelegateHTMLInputTextEditorImpl;
import org.itsnat.impl.comp.inplace.ItsNatCellEditorImpl;
import org.itsnat.impl.comp.mgr.ItsNatStfulDocComponentManagerImpl;
import org.itsnat.impl.comp.mgr.web.ItsNatHTMLDocComponentManagerImpl;
import org.itsnat.impl.comp.mgr.web.ItsNatXULDocComponentManagerImpl;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.scriptren.jsren.JSRenderMethodCallImpl;
import org.w3c.dom.Element;

public abstract class DelegateComponentEditorImpl
implements Serializable {
    protected ItsNatComponent compEditor;

    public DelegateComponentEditorImpl(ItsNatComponent compEditor) {
        this.compEditor = compEditor;
    }

    public static DelegateComponentEditorImpl createDelegateComponentEditor(ItsNatComponent compEditor, ItsNatCellEditorImpl parent) {
        if (compEditor != null) {
            if (compEditor instanceof ItsNatHTMLElementComponent) {
                return DelegateHTMLElementComponentEditorImpl.createDelegateHTMLElementComponentEditor((ItsNatHTMLElementComponent)compEditor);
            }
            throw new ItsNatException("This component is not supported as editor: " + compEditor, (Object)compEditor);
        }
        ItsNatStfulDocComponentManagerImpl compMgr = parent.getItsNatStfulDocComponentManager();
        if (compMgr instanceof ItsNatHTMLDocComponentManagerImpl) {
            return new DelegateHTMLInputTextEditorImpl(((ItsNatHTMLDocComponentManagerImpl)compMgr).createItsNatHTMLInputText(null, null));
        }
        if (compMgr instanceof ItsNatXULDocComponentManagerImpl) {
            throw new ItsNatException("Cannot be created a default component editor for this type of document");
        }
        throw new ItsNatException("Cannot be created a default component editor for this type of document");
    }

    public abstract Object getCellEditorValue();

    public abstract void preSetValue(Object var1);

    public abstract void setValue(Object var1);

    public ItsNatComponent getCellEditorComponent() {
        return this.compEditor;
    }

    public void setFocus() {
        ItsNatStfulDocumentImpl itsNatDoc = (ItsNatStfulDocumentImpl)this.compEditor.getItsNatDocument();
        Element elem = (Element)this.compEditor.getNode();
        JSRenderMethodCallImpl render = JSRenderMethodCallImpl.getJSRenderMethodCall(elem);
        ClientDocumentStfulImpl[] allClient = itsNatDoc.getAllClientDocumentStfulsCopy();
        for (int i = 0; i < allClient.length; ++i) {
            ClientDocumentStfulImpl clientDoc = allClient[i];
            if (!(clientDoc.getClientDocumentStfulDelegate() instanceof ClientDocumentStfulDelegateWebImpl)) continue;
            ClientDocumentStfulDelegateWebImpl clientDocDeleg = (ClientDocumentStfulDelegateWebImpl)clientDoc.getClientDocumentStfulDelegate();
            BrowserWeb browser = clientDocDeleg.getBrowserWeb();
            if (!clientDoc.isSendCodeEnabled() || render.isFocusOrBlurMethodWrong("focus", elem, browser)) continue;
            String code = JSRenderMethodCallImpl.getCallFormControlFocusBlurCodeDefault(elem, "focus", true, clientDocDeleg);
            clientDoc.addCodeToSend(code);
        }
    }
}

