/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.iframe;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KnownSizeInputStreamImpl
extends FilterInputStream {
    protected long sizeMax;
    protected long count;

    public KnownSizeInputStreamImpl(InputStream input, long sizeMax) {
        super(input);
        this.sizeMax = sizeMax;
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res == -1) {
            return -1;
        }
        if (this.count + 1L > this.sizeMax) {
            return -1;
        }
        ++this.count;
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res == -1) {
            return -1;
        }
        if (this.count == this.sizeMax) {
            return -1;
        }
        res = (int)this.updateCount(res);
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        long res = super.skip(n);
        if (res == 0L) {
            return 0L;
        }
        if (this.count == this.sizeMax) {
            return 0L;
        }
        res = this.updateCount(res);
        return res;
    }

    @Override
    public int available() throws IOException {
        int res = super.available();
        if (res == 0) {
            return 0;
        }
        if (this.count == this.sizeMax) {
            return 0;
        }
        return (int)this.correctReadedBytes(res);
    }

    protected long correctReadedBytes(long readedBytes) {
        if (this.count + readedBytes > this.sizeMax) {
            readedBytes = this.sizeMax - this.count;
        }
        return readedBytes;
    }

    protected long updateCount(long readedBytes) {
        readedBytes = this.correctReadedBytes(readedBytes);
        this.count += readedBytes;
        return readedBytes;
    }
}

