/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.iframe;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.itsnat.comp.iframe.FileUploadRequest;
import org.itsnat.comp.iframe.HTMLIFrameFileUpload;
import org.itsnat.comp.iframe.ItsNatHTMLIFrame;
import org.itsnat.core.ClientDocument;
import org.itsnat.core.ItsNatDOMException;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.core.event.ItsNatServletRequestListener;
import org.itsnat.impl.comp.iframe.FileUploadRequestImpl;
import org.itsnat.impl.comp.iframe.ItsNatHTMLIFrameImpl;
import org.itsnat.impl.core.ItsNatUserDataImpl;
import org.itsnat.impl.core.browser.web.BrowserMSIEOld;
import org.itsnat.impl.core.clientdoc.web.ClientDocumentStfulDelegateWebImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.domutil.DOMUtilHTML;
import org.itsnat.impl.core.domutil.DOMUtilInternal;
import org.itsnat.impl.core.mut.doc.BeforeAfterMutationRenderListener;
import org.itsnat.impl.core.mut.doc.DocMutationEventListenerImpl;
import org.itsnat.impl.core.servlet.ItsNatServletResponseImpl;
import org.itsnat.impl.core.util.HasUniqueId;
import org.itsnat.impl.core.util.UniqueId;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.html.HTMLIFrameElement;
import org.w3c.dom.html.HTMLInputElement;

public class HTMLIFrameFileUploadImpl
extends ItsNatUserDataImpl
implements HTMLIFrameFileUpload,
HasUniqueId,
Serializable,
BeforeAfterMutationRenderListener {
    protected ItsNatHTMLIFrameImpl comp;
    protected HTMLInputElement inputElem;
    protected ClientDocumentStfulDelegateWebImpl clientDoc;
    protected UniqueId idObj;
    protected LinkedList<ItsNatServletRequestListener> requestListeners;
    protected boolean receiving = false;
    protected boolean disposed = false;
    protected boolean processed = false;

    public HTMLIFrameFileUploadImpl(ItsNatHTMLIFrameImpl comp, HTMLInputElement inputElem, ClientDocumentStfulDelegateWebImpl clientDoc) {
        super(true);
        this.comp = comp;
        this.inputElem = inputElem;
        this.clientDoc = clientDoc;
        this.idObj = clientDoc.getClientDocumentStful().getUniqueIdGenerator().generateUniqueId("ifur");
        if (!DOMUtilHTML.isHTMLInputFile(inputElem)) {
            throw new ItsNatException("Expected an <input type='file'> element");
        }
        HTMLIFrameElement iframeElem = comp.getHTMLIFrameElement();
        String targetName = iframeElem.getAttribute("name");
        if (DOMUtilInternal.isNodeInside(iframeElem, null)) {
            if (targetName.equals("")) {
                throw new ItsNatDOMException("Expected a non-empty attribute name", (Node)iframeElem);
            }
        } else {
            if (targetName.equals("")) {
                targetName = "itsnat_iffu_" + this.idObj.getId();
            }
            iframeElem.setAttribute("name", targetName);
            Element rootElem = this.getItsNatStfulDocument().getVisualRootElement();
            rootElem.appendChild(iframeElem);
        }
        DocMutationEventListenerImpl mainListener = clientDoc.getItsNatStfulDocument().getDocMutationEventListener();
        mainListener.addBeforeAfterMutationRenderListener(iframeElem, this);
        clientDoc.addHTMLIFrameFileUploadImpl(this);
        comp.addHTMLIFrameFileUploadImpl(this);
        StringBuilder code = new StringBuilder();
        code.append("var elem = " + clientDoc.getNodeReference(inputElem, true, true) + ";\n");
        code.append("var elemClone = elem.cloneNode(true);\n");
        code.append("var parentNode = itsNatDoc.getParentNode(elem);\n");
        code.append("itsNatDoc.insertBefore(parentNode,elemClone,elem);\n");
        if (comp.getItsNatDocumentImpl() instanceof ItsNatHTMLDocumentImpl) {
            code.append("var form = itsNatDoc.doc.createElement(\"form\");\n");
        } else {
            code.append("var form = itsNatDoc.doc.createElementNS(\"http://www.w3.org/1999/xhtml\",\"form\");\n");
        }
        code.append("itsNatDoc.setAttribute(form,\"method\",\"post\");\n");
        code.append("itsNatDoc.setAttribute(form,\"enctype\",\"multipart/form-data\");\n");
        if (clientDoc.getBrowserWeb() instanceof BrowserMSIEOld) {
            code.append("form.encoding = \"multipart/form-data\";\n");
        }
        code.append("itsNatDoc.setAttribute(form,\"action\"," + this.getActionURL() + ");\n");
        code.append("itsNatDoc.setAttribute(form,\"target\",\"" + targetName + "\");\n");
        code.append("itsNatDoc.insertBefore(parentNode,form,elemClone);\n");
        code.append("itsNatDoc.appendChild(form,elem);\n");
        code.append("var oldName = elem.name;\n");
        String name = inputElem.getAttribute("name");
        if (name.equals("")) {
            name = "fileContent";
        }
        code.append("elem.name = \"" + name + "\";\n");
        code.append("form.submit();\n");
        code.append("elem.name = oldName;\n");
        code.append("itsNatDoc.removeChild(form);\n");
        code.append("itsNatDoc.insertBefore(parentNode,elem,elemClone);\n");
        code.append("itsNatDoc.removeChild(elemClone);\n");
        clientDoc.addCodeToSend(code);
    }

    public String getActionURL() {
        return "itsNatDoc.getServletPath() + \"?itsnat_action=iframe_file_upload&\" + itsNatDoc.genParamURL() + \"&itsnat_listener_id=" + this.idObj.getId() + "\"";
    }

    @Override
    public ClientDocument getClientDocument() {
        return this.clientDoc.getClientDocumentStful();
    }

    public ItsNatStfulDocumentImpl getItsNatStfulDocument() {
        return (ItsNatStfulDocumentImpl)this.comp.getItsNatDocumentImpl();
    }

    @Override
    public HTMLInputElement getHTMLInputElement() {
        return this.inputElem;
    }

    @Override
    public ItsNatHTMLIFrame getItsNatHTMLIFrame() {
        return this.comp;
    }

    @Override
    public String getId() {
        return this.idObj.getId();
    }

    @Override
    public UniqueId getUniqueId() {
        return this.idObj;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ItsNatStfulDocumentImpl itsNatDoc;
        ItsNatStfulDocumentImpl itsNatStfulDocumentImpl = itsNatDoc = this.clientDoc.getItsNatStfulDocument();
        synchronized (itsNatStfulDocumentImpl) {
            if (this.disposed) {
                return;
            }
            HTMLIFrameElement iframeElem = this.comp.getHTMLIFrameElement();
            DocMutationEventListenerImpl mainListener = this.clientDoc.getItsNatStfulDocument().getDocMutationEventListener();
            mainListener.removeBeforeAfterMutationRenderListener(iframeElem, this);
            this.clientDoc.removeHTMLIFrameFileUploadImpl(this);
            this.comp.removeHTMLIFrameFileUploadImpl(this);
            this.disposed = true;
        }
    }

    public void checkIsAlreadyUsed() {
        if (this.isDisposed()) {
            throw new ItsNatException("File upload processing is disposed");
        }
        if (this.receiving) {
            throw new ItsNatException("This " + HTMLIFrameFileUpload.class.getName() + " is already receiving client data", (Object)this);
        }
    }

    protected boolean hasItsNatServletRequestListeners() {
        if (this.requestListeners == null) {
            return false;
        }
        return !this.requestListeners.isEmpty();
    }

    protected LinkedList<ItsNatServletRequestListener> getItsNatServletRequestListenerList() {
        if (this.requestListeners == null) {
            this.requestListeners = new LinkedList();
        }
        return this.requestListeners;
    }

    protected Iterator<ItsNatServletRequestListener> getItsNatServletRequestListenerIterator() {
        if (this.requestListeners == null) {
            return null;
        }
        if (this.requestListeners.isEmpty()) {
            return null;
        }
        return this.requestListeners.iterator();
    }

    public void dispatchRequestListeners(ItsNatServletResponseImpl response) {
        if (this.isDisposed()) {
            return;
        }
        this.receiving = true;
        response.dispatchItsNatServletRequestListeners(this.getItsNatServletRequestListenerIterator());
        this.dispose();
    }

    @Override
    public void addItsNatServletRequestListener(ItsNatServletRequestListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<ItsNatServletRequestListener> requestListeners = this.getItsNatServletRequestListenerList();
        requestListeners.add(listener);
    }

    @Override
    public void removeItsNatServletRequestListener(ItsNatServletRequestListener listener) {
        this.checkIsAlreadyUsed();
        LinkedList<ItsNatServletRequestListener> requestListeners = this.getItsNatServletRequestListenerList();
        requestListeners.remove(listener);
    }

    @Override
    public void beforeRender(Node node, MutationEvent evt) {
        String type = evt.getType();
        if (type.equals("DOMNodeRemoved")) {
            this.dispose();
        }
    }

    @Override
    public void afterRender(Node node, MutationEvent evt) {
    }

    @Override
    public FileUploadRequest processFileUploadRequest(ItsNatServletRequest request, ItsNatServletResponse response) {
        if (this.processed) {
            throw new ItsNatException("File upload request processing is already executed");
        }
        this.processed = true;
        return new FileUploadRequestImpl(request, response);
    }
}

