/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.iframe;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import org.itsnat.comp.iframe.FileUploadRequest;
import org.itsnat.core.ItsNatException;
import org.itsnat.core.ItsNatServletRequest;
import org.itsnat.core.ItsNatServletResponse;
import org.itsnat.impl.comp.iframe.HTMLIFrameFileUploadImpl;
import org.itsnat.impl.comp.iframe.KnownSizeInputStreamImpl;

public class FileUploadRequestImpl
implements FileUploadRequest {
    protected static final byte CR = 13;
    protected static final byte LF = 10;
    protected static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    protected static final int HEADER_PART_SIZE_MAX = 10240;
    protected HTMLIFrameFileUploadImpl parent;
    protected String contentDispositionType;
    protected String contentDispositionName;
    protected String contentDispositionFileName;
    protected String contentType;
    protected KnownSizeInputStreamImpl fileStream;

    public FileUploadRequestImpl(ItsNatServletRequest request, ItsNatServletResponse response) {
        ServletInputStream input;
        ServletRequest servReq = request.getServletRequest();
        String encoding = servReq.getCharacterEncoding();
        int size = servReq.getContentLength();
        try {
            input = servReq.getInputStream();
        }
        catch (IOException ex) {
            throw new ItsNatException(ex);
        }
        int beginSepSize = FileUploadRequestImpl.readBeginSeparator((InputStream)input);
        int[] headerByteSize = new int[1];
        this.readHeaders((InputStream)input, encoding, headerByteSize);
        int endSepSize = beginSepSize + 4;
        int fileSize = size - beginSepSize - headerByteSize[0] - endSepSize;
        this.fileStream = new KnownSizeInputStreamImpl((InputStream)input, fileSize);
    }

    @Override
    public String getFieldName() {
        return this.contentDispositionName;
    }

    @Override
    public String getFileName() {
        return this.contentDispositionFileName;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getFileSize() {
        return this.fileStream.getSizeMax();
    }

    @Override
    public InputStream getFileUploadInputStream() {
        return this.fileStream;
    }

    public void processHeaders(String headers) {
        int pos = headers.indexOf("\r\n");
        while (pos > 0) {
            String header = headers.substring(0, pos);
            this.parseHeaderNameValue(header);
            headers = headers.substring(pos + 2);
            pos = headers.indexOf("\r\n");
        }
    }

    public void parseHeaderNameValue(String header) {
        String headerLower = header.toLowerCase();
        int pos = headerLower.indexOf("content-disposition:");
        if (pos == 0) {
            header = header.substring("content-disposition:".length());
            pos = header.indexOf(59);
            String dispType = header.substring(0, pos);
            this.contentDispositionType = dispType = dispType.trim();
            do {
                if ((pos = (header = header.substring(pos + 1)).indexOf(59)) == -1) {
                    pos = header.length();
                }
                String param = header.substring(0, pos);
                int posEq = (param = param.trim()).indexOf(61);
                if (posEq == -1) continue;
                String paramName = param.substring(0, posEq);
                String paramValue = param.substring(posEq + 1);
                paramValue = paramValue.substring(1, paramValue.length() - 1);
                if ("name".equals(paramName)) {
                    this.contentDispositionName = paramValue;
                    continue;
                }
                if (!"filename".equals(paramName)) continue;
                this.contentDispositionFileName = paramValue;
            } while (pos != header.length());
        } else {
            pos = headerLower.indexOf("content-type:");
            if (pos == 0) {
                header = header.substring("content-type:".length());
                this.contentType = header = header.trim();
            }
        }
    }

    public static int readBeginSeparator(InputStream input) {
        int b;
        int size = 0;
        do {
            try {
                b = input.read();
            }
            catch (IOException e) {
                throw new ItsNatException("Input stream ended unexpectedly");
            }
            ++size;
        } while (b != 13);
        try {
            b = input.read();
        }
        catch (IOException e) {
            throw new ItsNatException("Input stream ended unexpectedly");
        }
        if (b != 10) {
            throw new ItsNatException("Malformed header");
        }
        return ++size;
    }

    public String readHeaders(InputStream input, String encoding, int[] readedBytes) {
        String header;
        int i = 0;
        ByteArrayOutputStream byteHeader = new ByteArrayOutputStream();
        int size = 0;
        while (i < HEADER_SEPARATOR.length) {
            int b;
            try {
                b = input.read();
            }
            catch (IOException e) {
                throw new ItsNatException("Input stream ended unexpectedly");
            }
            if (++size > 10240) {
                throw new ItsNatException("Header section has more than 10240 bytes (maybe it is not properly terminated)");
            }
            i = b == HEADER_SEPARATOR[i] ? ++i : 0;
            byteHeader.write(b);
        }
        readedBytes[0] = readedBytes[0] + size;
        if (encoding != null) {
            try {
                header = byteHeader.toString(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                header = byteHeader.toString();
            }
        } else {
            header = byteHeader.toString();
        }
        this.processHeaders(header);
        return header;
    }
}

