/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.button.toggle;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import org.itsnat.comp.ItsNatComponent;
import org.itsnat.comp.button.ItsNatButtonGroup;
import org.itsnat.comp.button.toggle.ItsNatButtonRadio;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.comp.button.toggle.ItsNatButtonRadioInternal;

public class ItsNatButtonGroupImpl
implements ItsNatButtonGroup,
Serializable {
    protected String name;
    protected ButtonGroup group;
    protected List<ItsNatButtonRadio> buttonList = new LinkedList<ItsNatButtonRadio>();

    public ItsNatButtonGroupImpl(String name, ButtonGroup group) {
        if (group == null) {
            throw new ItsNatException("ButtonGroup cannot be null");
        }
        this.name = name;
        this.group = group;
    }

    public static void checkRadioButton(ItsNatComponent button) {
        if (!(button instanceof ItsNatButtonRadio)) {
            throw new ItsNatException("Only " + ItsNatButtonRadio.class.getName() + " components are supported", (Object)button);
        }
    }

    @Override
    public void addButton(ItsNatComponent button) {
        ItsNatButtonGroupImpl.checkRadioButton(button);
        this.addButton((ItsNatButtonRadioInternal)button, true);
    }

    public void addButton(ItsNatButtonRadioInternal button, boolean setInComponent) {
        this.buttonList.remove(button);
        this.buttonList.add(button);
        if (setInComponent) {
            button.setItsNatButtonGroup(this, false);
        }
    }

    @Override
    public void removeButton(ItsNatComponent button) {
        ItsNatButtonGroupImpl.checkRadioButton(button);
        this.removeButton((ItsNatButtonRadio)button, true);
    }

    public void removeButton(ItsNatButtonRadio button, boolean setInModel) {
        this.buttonList.remove(button);
        if (setInModel) {
            JToggleButton.ToggleButtonModel model = (JToggleButton.ToggleButtonModel)button.getButtonModel();
            model.setGroup(null);
            button.setItsNatButtonGroup(null);
        }
    }

    @Override
    public int getButtonCount() {
        return this.buttonList.size();
    }

    @Override
    public ItsNatComponent getButton(int index) {
        return this.buttonList.get(index);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ButtonGroup getButtonGroup() {
        return this.group;
    }
}

