/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp.button;

import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import org.itsnat.impl.comp.button.ItsNatButtonInternal;
import org.w3c.dom.events.Event;

public abstract class ItsNatButtonSharedImpl
implements Serializable {
    protected ItsNatButtonInternal comp;

    public ItsNatButtonSharedImpl(ItsNatButtonInternal comp) {
        this.comp = comp;
    }

    public void bindDataModel() {
        ButtonModel dataModel = this.comp.getButtonModel();
        dataModel.addChangeListener(this.comp);
    }

    public void unbindDataModel() {
        ButtonModel dataModel = this.comp.getButtonModel();
        dataModel.removeChangeListener(this.comp);
    }

    public void initialSyncUIWithDataModel() {
        this.syncUIWithDataModel();
    }

    public void syncUIWithDataModel() {
        ButtonModel dataModel = this.comp.getButtonModel();
        this.comp.setDOMEnabled(dataModel.isEnabled());
    }

    public void syncWithDataModel() {
        this.syncUIWithDataModel();
    }

    public void stateChanged(ChangeEvent e) {
        this.comp.syncWithDataModel();
    }

    public boolean handleEvent(Event evt) {
        return ItsNatButtonSharedImpl.handleEvent(this.comp.getButtonModel(), evt);
    }

    public static boolean handleEvent(ButtonModel dataModel, Event evt) {
        if (!dataModel.isEnabled()) {
            return false;
        }
        String type = evt.getType();
        if (type.equals("click")) {
            dataModel.setArmed(true);
            dataModel.setPressed(true);
            dataModel.setPressed(false);
            dataModel.setArmed(false);
        } else if (type.equals("mousedown")) {
            dataModel.setArmed(true);
            dataModel.setPressed(true);
        } else if (type.equals("mouseup")) {
            dataModel.setPressed(false);
            dataModel.setArmed(false);
        } else if (type.equals("mouseover")) {
            dataModel.setRollover(true);
        } else if (type.equals("mouseout")) {
            dataModel.setRollover(false);
            dataModel.setArmed(false);
        }
        return true;
    }
}

