/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.impl.comp;

import java.io.Serializable;
import org.itsnat.core.event.ItsNatEvent;
import org.itsnat.impl.comp.ItsNatHTMLFormCompChangeBased;
import org.itsnat.impl.comp.ItsNatHTMLFormComponentImpl;
import org.itsnat.impl.comp.listener.ItsNatCompNormalEventListenersByClientImpl;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.browser.web.webkit.BrowserWebKit;
import org.itsnat.impl.core.clientdoc.ClientDocumentImpl;
import org.itsnat.impl.core.event.server.dom.domstd.ServerItsNatDOMStdEventImpl;
import org.w3c.dom.events.Event;
import org.w3c.dom.html.HTMLElement;

public abstract class ItsNatHTMLFormCompChangeBasedSharedImpl
implements Serializable {
    protected ItsNatHTMLFormCompChangeBased comp;

    public ItsNatHTMLFormCompChangeBasedSharedImpl(ItsNatHTMLFormCompChangeBased comp) {
        this.comp = comp;
    }

    public ItsNatHTMLFormComponentImpl getItsNatHTMLFormComponent() {
        return (ItsNatHTMLFormComponentImpl)((Object)this.comp);
    }

    public void init() {
    }

    public boolean isChangeEvent(String type, ClientDocumentImpl clientDoc) {
        if (type.equals("change")) {
            return !this.isIgnoreChangeEvent(clientDoc);
        }
        if (type.equals("blur")) {
            return this.isBlurLikeChangeEvent(clientDoc);
        }
        return false;
    }

    public boolean isChangeEvent(Event evt) {
        String type = evt.getType();
        if (evt instanceof ServerItsNatDOMStdEventImpl && type.equals("blur")) {
            return false;
        }
        ClientDocumentImpl clientDoc = (ClientDocumentImpl)((ItsNatEvent)((Object)evt)).getClientDocument();
        return this.isChangeEvent(type, clientDoc);
    }

    public void enableEventListenersByDoc() {
        ItsNatHTMLFormComponentImpl comp = this.getItsNatHTMLFormComponent();
        comp.enableEventListener("change");
    }

    public void enableEventListenersByClient(ItsNatCompNormalEventListenersByClientImpl clientListeners) {
        if (this.isBlurLikeChangeEvent(clientListeners.getClientDocument())) {
            ItsNatHTMLFormComponentImpl comp = this.getItsNatHTMLFormComponent();
            comp.enableEventListener("blur", clientListeners);
        }
    }

    public void processNormalEvent(Event evt) {
        if (this.isChangeEvent(evt)) {
            this.comp.handleEventOnChange(evt);
            this.comp.postHandleEventOnChange(evt);
        }
    }

    public boolean isBlurLikeChangeEvent(ClientDocumentImpl clientDoc) {
        HTMLElement elem = this.comp.getHTMLElement();
        BrowserWeb browser = (BrowserWeb)clientDoc.getBrowser();
        return browser instanceof BrowserWebKit && ((BrowserWebKit)browser).isChangeEventNotFiredUseBlur(elem);
    }

    public boolean isIgnoreChangeEvent(ClientDocumentImpl clientDoc) {
        return false;
    }
}

