/*
 * Decompiled with CFR 0.152.
 */
package org.itsnat.core.domutil;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ItsNatTreeWalker {
    public static boolean hasChildElements(Node node) {
        return ItsNatTreeWalker.getFirstChildElement(node) != null;
    }

    public static int getChildElementCount(Node node) {
        int count = 0;
        Element child = ItsNatTreeWalker.getFirstChildElement(node);
        while (child != null) {
            ++count;
            child = ItsNatTreeWalker.getNextSiblingElement(child);
        }
        return count;
    }

    public static Element getFirstChildElement(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getLastChildElement(Node node) {
        for (Node child = node.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node) {
        for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static Element getPreviousSiblingElement(Node node) {
        for (Node sibling = node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static Element getParentElement(Node node) {
        if (node == null) {
            return null;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return null;
        }
        if (parent.getNodeType() == 1) {
            return (Element)parent;
        }
        return null;
    }

    public static Element getPreviousElement(Node node) {
        Element prevChild;
        if (node == null) {
            return null;
        }
        Element prevSibling = ItsNatTreeWalker.getPreviousSiblingElement(node);
        if (prevSibling == null) {
            return ItsNatTreeWalker.getParentElement(node);
        }
        Element lastChild = ItsNatTreeWalker.getLastChildElement(prevSibling);
        if (lastChild == null) {
            return prevSibling;
        }
        while ((lastChild = ItsNatTreeWalker.getLastChildElement(prevChild = lastChild)) != null) {
        }
        lastChild = prevChild;
        return lastChild;
    }

    public static Element getNextElement(Node node) {
        if (node == null) {
            return null;
        }
        Element result = ItsNatTreeWalker.getFirstChildElement(node);
        if (result != null) {
            return result;
        }
        result = ItsNatTreeWalker.getNextSiblingElement(node);
        if (result != null) {
            return result;
        }
        Element parent = ItsNatTreeWalker.getParentElement(node);
        while (parent != null) {
            result = ItsNatTreeWalker.getNextSiblingElement(parent);
            if (result != null) {
                return result;
            }
            parent = ItsNatTreeWalker.getParentElement(parent);
        }
        return null;
    }

    public static Node getPreviousNode(Node node) {
        Node prevChild;
        if (node == null) {
            return null;
        }
        Node prevSibling = node.getPreviousSibling();
        if (prevSibling == null) {
            return node.getParentNode();
        }
        Node lastChild = prevSibling.getLastChild();
        if (lastChild == null) {
            return prevSibling;
        }
        while ((lastChild = (prevChild = lastChild).getLastChild()) != null) {
        }
        lastChild = prevChild;
        return lastChild;
    }

    public static Node getNextNode(Node node) {
        if (node == null) {
            return null;
        }
        Node result = node.getFirstChild();
        if (result != null) {
            return result;
        }
        result = node.getNextSibling();
        if (result != null) {
            return result;
        }
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            result = parent.getNextSibling();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Element getFirstChildElementWithTagName(Node parent, String tagName) {
        Element child = ItsNatTreeWalker.getFirstChildElement(parent);
        while (child != null) {
            if (child.getTagName().equals(tagName)) {
                return child;
            }
            child = ItsNatTreeWalker.getNextSiblingElement(child);
        }
        return null;
    }

    public static Element getFirstChildElementWithTagNameNS(Node parent, String namespaceURI, String localName) {
        if (namespaceURI == null) {
            return ItsNatTreeWalker.getFirstChildElementWithTagName(parent, localName);
        }
        Element child = ItsNatTreeWalker.getFirstChildElement(parent);
        while (child != null) {
            if (namespaceURI.equals(child.getNamespaceURI()) && localName.equals(child.getLocalName())) {
                return child;
            }
            child = ItsNatTreeWalker.getNextSiblingElement(child);
        }
        return null;
    }

    public static Element getFirstDeepestChildElement(Node node) {
        Element parent = null;
        Element child = ItsNatTreeWalker.getFirstChildElement(node);
        while (child != null) {
            parent = child;
            child = ItsNatTreeWalker.getFirstChildElement(parent);
        }
        return parent;
    }
}

