/*
  ItsNat Java Web Application Framework
  Copyright (C) 2007-2011 Jose Maria Arranz Santamaria, Spanish citizen

  This software is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 3 of
  the License, or (at your option) any later version.
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details. You should have received
  a copy of the GNU Lesser General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.
*/

package org.itsnat.impl.core.servlet;

import java.security.MessageDigest;
import javax.servlet.http.HttpSession;
import org.itsnat.core.ItsNatException;
import org.itsnat.impl.core.util.*;

/**
 *
 * @author jmarranz
 */
public class ItsNatServletContextUniqueIdGenImpl implements UniqueIdGenerator
{
    protected MessageDigest md;
    protected ItsNatServletContextImpl context;
    protected UniqueIdGenIntList genIntList;
    protected UniqueIdGenMessageDigest genMesDigest;
    protected boolean frozen = false;

    /** Creates a new instance of UniqueIdGenerator */
    public ItsNatServletContextUniqueIdGenImpl(ItsNatServletContextImpl context)
    {
        this.context = context;
        initIdGenerators();
    }

    public void initIdGenerators()
    {
        if (context.isSessionReplicationCapable())
        {
            this.genIntList = null;
            this.genMesDigest = new UniqueIdGenMessageDigest();
        }
        else
        {
            this.genIntList = new UniqueIdGenIntList(true);
            this.genMesDigest = null;
        }
    }

    public void notifySessionReplicationCapableChanged()
    {
        if (frozen) throw new ItsNatException("Too late some servlet has already received events");
        initIdGenerators();
    }

    public UniqueId generateUniqueId(HttpSession session,String prefix)
    {
        this.frozen = true;

        String id;
        if (context.isSessionReplicationCapable())
        {
            // Este mtodo genera un id nico si el idRef es nico usando SHA-1
            // Es til (y es su nico uso) en la generacin del id de sesin
            // de ItsNat cuando se usa replicacin de sesiones por ejemplo en GAE
            // pues el ItsNatServletContextImpl no puede compartirse entre nodos
            // (se podra usando una cach compartida y algn mtodo atmico)
            // por tanto el enfoque de generacin de ids nicos usando enteros
            // no nos vale pues deben ser nicos para todos los nodos.
            // El generar un id SHA diferente al id de la sesin original y no reversible es importante
            // porque en control remoto este id es pblico para poder acceder a una sesin
            // de un usuario diferente, este id de ItsNat slo ser til en ItsNat
            // y sus acciones posibles estarn controladas por ItsNat (autorizacin etc)
            // si publicramos el id nativo de la sesin estaramos dando control
            // ABSOLUTO al usuario controlador ms all de ItsNat.

            id = genMesDigest.generateId(session.getId(),prefix);
        }
        else
        {
            id = genIntList.generateId(prefix);
        }

        return new UniqueId(id,this);
    }

}
