/*
  ItsNat Java Web Application Framework
  Copyright (C) 2007-2014 Jose Maria Arranz Santamaria, Spanish citizen

  This software is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 3 of
  the License, or (at your option) any later version.
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details. You should have received
  a copy of the GNU Lesser General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.
*/

package org.itsnat.impl.core.resp.norm.web;

import org.itsnat.core.CommMode;
import org.itsnat.impl.core.CommModeImpl;
import org.itsnat.impl.core.browser.web.BrowserSVGPlugin;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.clientdoc.ClientDocumentStfulImpl;
import org.itsnat.impl.core.doc.web.ItsNatHTMLDocumentImpl;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.listener.dom.domstd.OnUnloadListenerImpl;
import org.itsnat.impl.core.listener.dom.domstd.RegisterThisDocAsReferrerListenerImpl;
import org.itsnat.impl.core.req.norm.RequestNormalLoadDocImpl;
import org.itsnat.impl.core.resp.norm.ResponseNormalLoadStfulDocImpl;
import org.w3c.dom.Document;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

/**
 *
 * @author jmarranz
 */
public abstract class ResponseNormalLoadStfulWebDocImpl extends ResponseNormalLoadStfulDocImpl
{
    public ResponseNormalLoadStfulWebDocImpl(RequestNormalLoadDocImpl request)
    {
        super(request);
    }
    
    public static ResponseNormalLoadStfulWebDocImpl createResponseNormalLoadStfulWebDoc(RequestNormalLoadDocImpl request)
    {
        ItsNatStfulDocumentImpl itsNatDoc = (ItsNatStfulDocumentImpl)request.getItsNatDocument();
        if (itsNatDoc instanceof ItsNatHTMLDocumentImpl)
            return new ResponseNormalLoadHTMLDocImpl(request);
        else
            return new ResponseNormalLoadOtherNSDocImpl(request);
    }    
    
    @Override
    public void dispatchRequestListeners()
    {
        // Caso de carga del documento por primera vez, el documento est recin creado

        ItsNatStfulDocumentImpl itsNatDoc = getItsNatStfulDocument();
        Document doc = itsNatDoc.getDocument();
        AbstractView view = ((DocumentView)doc).getDefaultView();
        ClientDocumentStfulImpl clientDoc = getClientDocumentStful();
        BrowserWeb browser = (BrowserWeb)clientDoc.getBrowser();

        if (isReferrerEnabled())
        {
            EventTarget target;
            String eventType;
            int commMode;
            if (!(browser instanceof BrowserSVGPlugin))
            {
                target = (EventTarget)view;
                if ( CommModeImpl.isXHRDefaultMode(clientDoc) &&
                     browser.hasBeforeUnloadSupport(itsNatDoc) &&
                     itsNatDoc.isUseXHRSyncOnUnloadEvent())
                {
                    // Si no se soporta el modo sncrono corremos el riesgo de que no se enve el evento en el proceso de cerrado de la pgina
                    // lo cual normalmente ocurre en el evento "unload"
                    eventType = "beforeunload";
                    commMode = CommMode.XHR_SYNC; // As aseguramos que se enva pues por ejemplo no hay seguridad en modo asncrono en MSIE 6 desktop
                }
                else
                {
                    // Intentamos soportar referrers tambin aunque de forma menos elegante.
                    // Registramos en el evento load y no cuando se carga el documento
                    // para evitar solapamiento con posibles iframes
                    eventType = "load";
                    commMode = clientDoc.getCommMode();
                }
            }
            else
            {
                target = (EventTarget)doc.getDocumentElement();
                eventType = "SVGLoad";
                commMode = clientDoc.getCommMode();
            }

            clientDoc.addEventListener(target,eventType,RegisterThisDocAsReferrerListenerImpl.SINGLETON,false,commMode);
        }

        // Es necesario usar siempre el modo sncrono con unload para asegurar que llega al servidor
        // sobre todo con FireFox, total es destruccin
        // En FireFox a veces el unload se enva pero no llega al servidor en el caso de AJAX asncrono,
        // la culpa la tiene quizs el enviar por red asncronamente algo en el proceso de destruccin de la pgina
        // Curiosamente esto slo ocurre cuando se abre un visor remoto Comet y se cierra la pgina principal.
        // En teora "beforeunload" debera dar menos problemas que unload en FireFox
        // pero sin embargo tambin ocurri con beforeunload asncrono (adems beforeunload es cancelable).
        // NOTA: es posible que en versiones recientes est solucionado esto.
        // De todas formas es til el modo sncrono porque si hubiera algn
        // JavaScript pendiente de enviar, pues evita que de error al haberse perdido la pgina
        // (pues el navegador ha de esperarse, no destruye la pgina), si fuera asincrono
        // seguira destruyendo la pgina antes de retornar el evento (comprobado en MSIE y FireFox).

        super.dispatchRequestListeners();

        // En W3C en addEventListener el orden de dispatch es el mismo que el orden de insercin
        // y en MSIE hemos simulado lo mismo (lo natural es primero el ltimo)
        // por ello insertamos despus de los listeners del usuario tal que
        // nuestro unload "destructor" (invalida/desregistra el documento) sea el ltimo

        // Si se puede, los eventos de descarga deben enviarse como sncronos

        EventTarget target;
        String eventType;
        int commMode;
        int defaultCommMode = clientDoc.getCommMode();
        if (CommModeImpl.isXHRMode(defaultCommMode))
        {
            if (!itsNatDoc.isUseXHRSyncOnUnloadEvent()) // Este problema no se ha estudiado para SVGUnLoad pero por si acaso tambin lo consideramos
                commMode = CommMode.XHR_ASYNC;
            else
                commMode = CommMode.XHR_SYNC;
        }
        else commMode = defaultCommMode; // Caso SCRIPT o SCRIPT_HOLD, siempre asncronos

        if (!(browser instanceof BrowserSVGPlugin))
        {
            target = (EventTarget)view;
            eventType = "unload";
        }
        else
        {
            // En algunos plugins no se dispara por ejemplo ASV (v3 y v6) o Batik.
            target = (EventTarget)doc.getDocumentElement();
            eventType = "SVGUnload";
        }

        clientDoc.addEventListener(target,eventType,OnUnloadListenerImpl.SINGLETON,false,commMode);
    }    
}
