/*
  ItsNat Java Web Application Framework
  Copyright (C) 2007-2011 Jose Maria Arranz Santamaria, Spanish citizen

  This software is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 3 of
  the License, or (at your option) any later version.
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details. You should have received
  a copy of the GNU Lesser General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.
*/

package org.itsnat.impl.core.resp.norm;

import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.browser.web.BrowserWeb;
import org.itsnat.impl.core.listener.dom.domstd.OnLoadBackForwardListenerImpl;
import org.itsnat.impl.core.req.norm.RequestNormalEventImpl;
import org.itsnat.impl.core.scriptren.shared.JSAndBSRenderImpl;

/**
 *
 * @author jmarranz
 */
public class ResponseNormalEventErrorLostClientDocImpl extends ResponseNormalEventErrorImpl
{
    protected String lostClientId; // No se usa

    /**
     * Creates a new instance of ResponseNormalEventErrorLostClientDocImpl
     */
    public ResponseNormalEventErrorLostClientDocImpl(RequestNormalEventImpl request,String lostClientId)
    {
        super(request);

        this.lostClientId = lostClientId;
    }

    @Override
    public void processEvent()
    {
        // Antes hemos comprobado que no es un evento unload y que la sesin
        // no es la que se ha perdido.

        /*
         Casos:
         1) Ocurre en Opera 9 y BlackBerryOld pudiendo ser un back o forward volviendo
         a una pgina que sali haciendo un unload y que por tanto
         ya no existe (la sesin est bien), el problema es que el navegador no recarga la pgina del servidor
         sino que usa la cach y no recarga la pgina desde el servidor,
         pero en lo dems es igual generando un evento load,
         de hecho aadimos un evento load especial precisamente
         para solucionar este problema (de que se vuelva a una pgina
         en el cliente eliminada en el servidor). En los dems navegadores
         esto no ocurre porque se recarga un documento nuevo.

         Si es otro tipo de evento puede ser un evento generado por JavaScript
         como parte del handler onload de la propia pgina (que se ejecut antes del listener que
         enva al servidor el evento) y que tambin es escuchado tambin desde el servidor.
         Tambin puede ser el caso de navegador que no emite el evento load al volver via back
         (tpico de algunos browser mviles) y el usuario simplemente ha pulsado algo que emite evento al servidor.
         Por eso no chequeamos el tipo de evento.

         2) Tambin ocurre cuando se invalid en el servidor por cdigo el documento (sin necesariamente cerrar la ventana)
         por alguna razn (el programador puede llamar a setInvalid del documento)
         el framework lo hace por ejemplo cuando hay demasiados documentos abiertos.

         Son dos situaciones diferentes, en Opera nos interesa recargar la pgina
         para conseguir que funcione el back/forward, en el otro caso no hay esa excusa
         y si queremos podemos provocar un error (suponemos evento unload o beforeunload excluidos)
         */

        RequestNormalEventImpl request = getRequestNormalEvent();
        Browser browser = getClientDocumentWithoutDocumentDefault().getBrowser();

        if (browser instanceof BrowserWeb && ((BrowserWeb)browser).isCachedBackForwardExecutedScripts())
        {
            // Esperamos "con seguridad" el evento especial load/DOMContentLoaded marcado con "itsnat_check_reload"
            // con la finalidad de recargar la pgina, cualquier otro evento lo ignoraremos (no reload)
            // para evitar varios reload, por ejemplo podra ser el caso de un evento "load" normal, dicho evento
            // ha podido enviarse despus del evento especial pero antes de que el JavaScript de recarga tenga efecto,
            // evitamos por tanto generar otro JavaScript de recarga
            // El problema que introduce es que este reload aade una nueva
            // entrada a la cach del navegador.
            boolean loadBackForwardEvent = OnLoadBackForwardListenerImpl.isLoadBackForwardEvent(request);
            if (loadBackForwardEvent)
            {
                sendReload();
                return;
            }
            else if (request.isLoadEvent())
            {
                // No es un evento load tipo back/forward, lo ignoramos pues antes o despus viene el que recarga la pgina
                return;
            }
            // Si llegamos aqu es un evento cualquiera como click, no sabemos exactamente qu ha pasado, delegaremos
            // a los global listeners para que decidan
        }

        if (request.isLoadEvent())
        {
            // No sabemos qu ha pasado ni que caso de navegador es, lo que
            // parece claro es que la pgina cliente quiere cargarse
            // Una posible explicacin es que la pgina contenga iframes
            // y que al cargar los iframes hayamos superado el nmero de
            // documentos abiertos mximo por sesin y que por tanto
            // este evento load llega cuando el documento ha sido invalidado.
            // La solucin es aumentar el nmero de documentos por sesin.
            // Para cualquier otro caso de posible cacheo no previsto, lo
            // propio es recargar.
            sendReload();
            return;
        }

        // Es un evento cualquiera de una pgina perdida (invalidada en el servidor)
        // Damos una oportunidad a los listeners globales a recargar la pgina
        // o a redireccionar a otra o lo que sea

        if (!processGlobalListeners())
        {
            // No hay global listeners:
            // Podramos lanzar un error, pero queda ms elegante recargar la pgina
            sendReload();
        }
    }

    public void sendReload()
    {
        Browser browser = getClientDocumentWithoutDocumentDefault().getBrowser();
        getItsNatServletResponse().addCodeToSend(JSAndBSRenderImpl.getReloadCode(browser));
    }
}
