/*
  ItsNat Java Web Application Framework
  Copyright (C) 2007-2011 Jose Maria Arranz Santamaria, Spanish citizen

  This software is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 3 of
  the License, or (at your option) any later version.
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details. You should have received
  a copy of the GNU Lesser General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.
*/

package org.itsnat.impl.core.clientdoc;

import org.itsnat.impl.core.servlet.ItsNatSessionImpl;
import org.itsnat.impl.core.browser.Browser;
import org.itsnat.impl.core.doc.ItsNatStfulDocumentImpl;
import org.itsnat.impl.core.listener.attachcli.ItsNatAttachedClientTimerEventListenerWrapperImpl;
import org.itsnat.impl.core.scriptren.shared.listener.attachcli.JSAndBSRenderItsNatAttachedClientTimerEventListenerImpl;

/**
 *
 * @author jmarranz
 */
public class ClientDocumentAttachedClientTimerImpl extends ClientDocumentAttachedClientImpl
{
    protected int interval;
    protected ItsNatAttachedClientTimerEventListenerWrapperImpl listener;

    /** Creates a new instance of ClientDocumentAttachedClientTimerImpl */
    public ClientDocumentAttachedClientTimerImpl(boolean readOnly,int interval,int commMode,long eventTimeout,long waitDocTimeout,Browser browser,ItsNatSessionImpl session,ItsNatStfulDocumentImpl itsNatDoc)
    {
        super(readOnly,commMode,eventTimeout,waitDocTimeout,browser,session,itsNatDoc);

        this.interval = interval;
    }

    @Override
    public String getAttachType()
    {
        return "attach_timer";
    }    
    
    @Override
    public void startAttachedClient()
    {
        this.listener = new ItsNatAttachedClientTimerEventListenerWrapperImpl(this);
    }

    public ItsNatAttachedClientTimerEventListenerWrapperImpl getItsNatAttachedClientTimerEventListenerWrapper()
    {
        return listener;
    }

    public int getRefreshInterval()
    {
        return interval;
    }

    @Override
    protected void setInvalidInternal()
    {
        super.setInvalidInternal();

        addCodeToSend(JSAndBSRenderItsNatAttachedClientTimerEventListenerImpl.stopAttachTimerRefresh()); 
    }

    @Override
    public String getRefreshMethod()
    {
        return "timer";
    }
}
