/*
  ItsNat Java Web Application Framework
  Copyright (C) 2007-2011 Jose Maria Arranz Santamaria, Spanish citizen

  This software is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 3 of
  the License, or (at your option) any later version.
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details. You should have received
  a copy of the GNU Lesser General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.
*/

package org.itsnat.impl.core.browser.web.opera;

import org.itsnat.impl.core.browser.web.BrowserW3C;
import java.util.Map;
import org.itsnat.impl.core.scriptren.jsren.node.html.JSRenderHTMLElementImpl;
import org.itsnat.impl.core.scriptren.jsren.node.html.w3c.JSRenderHTMLElementOperaOldImpl;
import org.itsnat.impl.core.servlet.ItsNatServletRequestImpl;

/**
  En Opera el unload no se dispara siempre y onbeforeunload no est definido
  http://www.quirksmode.org/bugreports/archives/2004/11/load_and_unload.html

 * @author jmarranz
 */
public abstract class BrowserOperaOld extends BrowserW3C
{
    public static final int OPERA_OLD_DESKTOP = 1;
    public static final int OPERA_OLD_MINI = 2;
    public static final int OPERA_OLD_MOBILE = 3;

    /** Creates a new instance of BrowserOpera */
    public BrowserOperaOld(String userAgent)
    {
        super(userAgent);

        this.browserType = OPERA_OLD;
    }

    public static BrowserOperaOld createBrowserOperaOld(String userAgent)
    {
        if (BrowserOperaOldMini.isOperaMini(userAgent))
            return new BrowserOperaOldMini(userAgent);
        else if (BrowserOperaOldMobile.isOperaOldMobile(userAgent))
            return new BrowserOperaOldMobile(userAgent);
        else
            return new BrowserOperaOldDesktop(userAgent);
    }

    public static boolean isOperaOld(String userAgent,ItsNatServletRequestImpl itsNatRequest)
    {
        return (userAgent.contains("Opera"));
    }

    @Override
    public boolean hasBeforeUnloadSupportHTML()
    {
        return false; // Tampoco en HTML
    }

    @Override
    public boolean isReferrerReferenceStrong()
    {
        // El back/forward est cacheado en el cliente.
        return true;
    }

    @Override
    public boolean isCachedBackForward()
    {
        // Opera Mini: slo tiene Back
        return true;
    }

    @Override
    public boolean isDOMContentLoadedSupported()
    {
        return true;
    }

    @Override
    public boolean canNativelyRenderOtherNSInXHTMLDoc()
    {
        return true; // Soporta SVG al menos.
    }

    @Override
    public boolean isInsertedSVGScriptNotExecuted()
    {
        return false;
    }

    @Override
    public boolean isTextAddedToInsertedSVGScriptNotExecuted()
    {
        // En Opera 9 desktop el texto del script se ejecuta si
        // se inserta junto al elemento <script>, no funciona si es despus
        // En Opera 10 funciona bien en ambos casos, la solucin al problema
        // es compatible con que funcione bien pues en la reinsercin no se ejecuta de nuevo.
        // En Opera Mobile 9.5 y 9.7 Win Mobile funcionan bien con esta solucin.
        // En Opera Mobile 9.5 UIQ el navegador es un visor de SVG sin scripts o funciona mal por lo menos.
        // En Opera Mini 4 no hay problema pues el render siempre es lo ltimo de Opera.
        return true;
    }    
    
    
    @Override
    public Map<String,String[]> getHTMLFormControlsIgnoreZIndex()
    {
        // En teora todos los elementos no ignoran el z-index, sin embargo
        // aunque Opera Mobile 9.x est diseado para pantallas tctiles,
        // hasta cierto punto soporta navegacin por cursores,
        // y he descubierto que a travs de los cursores podemos llegar y "pulsar"
        // todos los elementos con listeners de layers por debajo, tanto en Win CE como en Symbian.

        // El problema es que cualquier elemento no form con
        // un listener "click" es susceptible tambin de llegarse a l usando
        // los cursores, desafortunadamente "el cuadro de foco" se muestra
        // al pasar por el mismo.

        // No consideramos ese caso pues su pulsacin es premeditada o accidental
        // y en ese caso lo que hacemos es lanzar una excepcin.

        return null;
    }    
    
    @Override
    public JSRenderHTMLElementImpl getJSRenderHTMLElementSingleton() 
    {
        return getJSRenderHTMLElementSingletonStatic(); 
    }    
    
    public static JSRenderHTMLElementImpl getJSRenderHTMLElementSingletonStatic() 
    {
        return JSRenderHTMLElementOperaOldImpl.SINGLETON; 
    }        
}
