/*
  ItsNat Java Web Application Framework
  Copyright (C) 2007-Present Jose Maria Arranz Santamaria, Spanish citizen

  This software is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 3 of
  the License, or (at your option) any later version.
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details. You should have received
  a copy of the GNU Lesser General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.
*/
package org.itsnat.impl.core.browser.web;

import java.util.Map;
import org.w3c.dom.html.HTMLElement;

/**
 * Se usa porque algunos plugins SVG no admiten eventos load/unload en window
 * 
 * @author jmarranz
 */
public abstract class BrowserSVGPlugin extends BrowserW3C
{
    public BrowserSVGPlugin(String userAgent)
    {
        super(userAgent);   
    }
    
    @Override
    public boolean isMobile()
    {
        return false;
    }    
    
    @Override
    public boolean isReferrerReferenceStrong()
    {
        // No funciona la navegacin desde el SVG por lo que nos
        // da igual los referrers.
        return false;
    }   
    
    @Override
    public boolean isCachedBackForward()
    {
        // No hay back/forward
        return false;
    }

    @Override
    public boolean isCachedBackForwardExecutedScripts()
    {
        // No hay back/forward
        return false;
    }
    
    @Override
    public boolean isDOMContentLoadedSupported()
    {
        // window ni siquiera es EventTarget en Batik applet        
        return false;
    }    
    
    @Override
    public boolean isFocusOrBlurMethodWrong(String methodName,HTMLElement formElem)
    {
        return false; // Por poner algo, Batik no renderiza HTML embebido en SVG
    }    
    
    @Override
    public Map<String,String[]> getHTMLFormControlsIgnoreZIndex()
    {
        // No se reconoce XHTML embebido.
        return null;
    }    
    

    @Override
    public boolean canNativelyRenderOtherNSInXHTMLDoc()
    {
        return false; // Renderiza SVG pero no el propio XHTML.
    }    
    
    @Override
    public boolean isInsertedSVGScriptNotExecuted()
    {
        // No se ejecuta de ninguna forma
        // En ASV (ambas v3 y v6) no funciona ni insertado antes ni despus
        return true;
    }

    @Override
    public boolean isTextAddedToInsertedSVGScriptNotExecuted()
    {
        // No se ejecuta de ninguna forma        
        return true;
    }    
    
    @Override
    public boolean hasBeforeUnloadSupportHTML()
    {
        return false; // Esto es slo SVG
    }    
}
