/*
  ItsNat Java Web Application Framework
  Copyright (C) 2007-2011 Jose Maria Arranz Santamaria, Spanish citizen

  This software is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 3 of
  the License, or (at your option) any later version.
  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details. You should have received
  a copy of the GNU Lesser General Public License along with this program.
  If not, see <http://www.gnu.org/licenses/>.
*/

package org.itsnat.impl.comp.inplace;

import org.itsnat.comp.ItsNatHTMLElementComponent;
import org.itsnat.comp.button.toggle.ItsNatHTMLInputCheckBox;
import org.itsnat.comp.list.ItsNatHTMLSelectComboBox;
import org.itsnat.comp.text.ItsNatHTMLInputText;
import org.itsnat.comp.text.ItsNatHTMLTextArea;
import org.itsnat.core.ItsNatException;

/**
 *
 * @author jmarranz
 */
public abstract class DelegateHTMLElementComponentEditorImpl extends DelegateComponentEditorImpl
{
    public DelegateHTMLElementComponentEditorImpl(ItsNatHTMLElementComponent compEditor)
    {
        super(compEditor);
    }

    public static DelegateHTMLElementComponentEditorImpl createDelegateHTMLElementComponentEditor(ItsNatHTMLElementComponent compEditor)
    {
        if (compEditor instanceof ItsNatHTMLInputText)
            return new DelegateHTMLInputTextEditorImpl((ItsNatHTMLInputText)compEditor);
        else if (compEditor instanceof ItsNatHTMLSelectComboBox)
            return new DelegateHTMLSelectComboBoxEditorImpl((ItsNatHTMLSelectComboBox)compEditor);
        else if (compEditor instanceof ItsNatHTMLInputCheckBox)
            return new DelegateHTMLInputCheckBoxEditorImpl((ItsNatHTMLInputCheckBox)compEditor);
        else if (compEditor instanceof ItsNatHTMLTextArea)
            return new DelegateHTMLTextAreaEditorImpl((ItsNatHTMLTextArea)compEditor);
        else
            throw new ItsNatException("This component is not supported as editor: " + compEditor,compEditor);
    }
}
