/*
 * Decompiled with CFR 0.152.
 */
package org.isomorphism.util;

import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import org.isomorphism.util.TokenBucket;

public class FixedIntervalRefillStrategy
implements TokenBucket.RefillStrategy {
    private final Ticker ticker;
    private final long numTokens;
    private final long periodInNanos;
    private long nextRefillTime;

    public FixedIntervalRefillStrategy(Ticker ticker, long numTokens, long period, TimeUnit unit) {
        this.ticker = ticker;
        this.numTokens = numTokens;
        this.periodInNanos = unit.toNanos(period);
        this.nextRefillTime = -1L;
    }

    public synchronized long refill() {
        long now = this.ticker.read();
        if (now < this.nextRefillTime) {
            return 0L;
        }
        this.nextRefillTime = now + this.periodInNanos;
        return this.numTokens;
    }

    public long getDurationUntilNextRefill(TimeUnit unit) {
        long now = this.ticker.read();
        return unit.convert(Math.max(0L, this.nextRefillTime - now), TimeUnit.NANOSECONDS);
    }
}

