/*
 * Decompiled with CFR 0.152.
 */
package org.isomorphism.util;

import com.google.common.base.Preconditions;
import org.isomorphism.util.TokenBucket;

class TokenBucketImpl
implements TokenBucket {
    private final long capacity;
    private final TokenBucket.RefillStrategy refillStrategy;
    private final TokenBucket.SleepStrategy sleepStrategy;
    private long size;

    TokenBucketImpl(long capacity, TokenBucket.RefillStrategy refillStrategy, TokenBucket.SleepStrategy sleepStrategy) {
        Preconditions.checkArgument((capacity > 0L ? 1 : 0) != 0);
        this.capacity = capacity;
        this.refillStrategy = (TokenBucket.RefillStrategy)Preconditions.checkNotNull((Object)refillStrategy);
        this.sleepStrategy = (TokenBucket.SleepStrategy)Preconditions.checkNotNull((Object)sleepStrategy);
        this.size = 0L;
    }

    public boolean tryConsume() {
        return this.tryConsume(1L);
    }

    public synchronized boolean tryConsume(long numTokens) {
        Preconditions.checkArgument((numTokens > 0L ? 1 : 0) != 0, (Object)"Number of tokens to consume must be positive");
        Preconditions.checkArgument((numTokens <= this.capacity ? 1 : 0) != 0, (Object)"Number of tokens to consume must be less than the capacity of the bucket.");
        long newTokens = Math.min(this.capacity, Math.max(0L, this.refillStrategy.refill()));
        this.size = Math.max(0L, Math.min(this.size + newTokens, this.capacity));
        if (numTokens <= this.size) {
            this.size -= numTokens;
            return true;
        }
        return false;
    }

    public void consume() {
        this.consume(1L);
    }

    public void consume(long numTokens) {
        while (!this.tryConsume(numTokens)) {
            this.sleepStrategy.sleep();
        }
    }
}

