/*
 * Decompiled with CFR 0.152.
 */
package org.isomorphism.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;

public class TokenBucket {
    private final RefillStrategy refillStrategy;
    private final long capacity;
    private long size;

    public TokenBucket(long capacity, RefillStrategy refillStrategy) {
        this.refillStrategy = refillStrategy;
        this.capacity = capacity;
        this.size = 0L;
    }

    public boolean tryConsume() {
        return this.tryConsume(1L);
    }

    public synchronized boolean tryConsume(long numTokens) {
        Preconditions.checkArgument((numTokens > 0L ? 1 : 0) != 0, (Object)"Number of tokens to consume must be positive");
        Preconditions.checkArgument((numTokens <= this.capacity ? 1 : 0) != 0, (Object)"Number of tokens to consume must be less than the capacity of the bucket.");
        long newTokens = Math.max(0L, this.refillStrategy.refill());
        this.size = Math.max(0L, Math.min(this.size + newTokens, this.capacity));
        if (numTokens <= this.size) {
            this.size -= numTokens;
            return true;
        }
        return false;
    }

    public void consume() {
        this.consume(1L);
    }

    public void consume(long numTokens) {
        while (!this.tryConsume(numTokens)) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.NANOSECONDS);
        }
    }

    public static interface RefillStrategy {
        public long refill();
    }
}

