/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.instancio.Random;
import org.instancio.junit.InstancioSource;
import org.instancio.junit.internal.ElementAnnotations;
import org.instancio.junit.internal.ExtensionSupport;
import org.instancio.junit.internal.ObjectCreator;
import org.instancio.junit.internal.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.instancio.support.Global;
import org.instancio.support.ThreadLocalRandom;
import org.instancio.support.ThreadLocalSettings;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class InstancioSourceArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<InstancioSource> {
    private InstancioSource instancioSource;

    public void accept(InstancioSource instancioSource) {
        this.instancioSource = instancioSource;
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.getInstance();
        ThreadLocalSettings threadLocalSettings = ThreadLocalSettings.getInstance();
        ExtensionSupport.processAnnotations(context, threadLocalRandom, threadLocalSettings);
        Random random = threadLocalRandom.get();
        Settings settings = threadLocalSettings.get();
        Parameter[] parameters = context.getRequiredTestMethod().getParameters();
        int samples = this.getNumberOfSamples(settings);
        return Stream.generate(() -> Arguments.of((Object[])InstancioSourceArgumentsProvider.createObjects(parameters, random, settings))).limit(samples);
    }

    private int getNumberOfSamples(Settings threadLocalSettings) {
        Integer samples;
        if (this.instancioSource.samples() > 0) {
            return this.instancioSource.samples();
        }
        if (threadLocalSettings != null && (samples = (Integer)threadLocalSettings.get(Keys.INSTANCIO_SOURCE_SAMPLES)) != null) {
            return samples;
        }
        return (Integer)Global.getPropertiesFileSettings().get(Keys.INSTANCIO_SOURCE_SAMPLES);
    }

    private static Object[] createObjects(Parameter[] parameters, Random random, Settings settings) {
        return Arrays.stream(parameters).map(param -> {
            Type targetType = param.getParameterizedType();
            List<Annotation> annotations = ReflectionUtils.collectionAnnotations(param);
            ElementAnnotations elementAnnotations = new ElementAnnotations(annotations);
            return new ObjectCreator(settings, random).createObject((AnnotatedElement)param, targetType, elementAnnotations);
        }).toArray();
    }
}

