/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.instancio.GetMethodSelector;
import org.instancio.Scope;
import org.instancio.SetMethodSelector;
import org.instancio.TargetSelector;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.selectors.PredicateScopeImpl;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.SelectorBuilder;
import org.instancio.internal.selectors.SelectorGroupImpl;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.selectors.SetterSelectorHolder;
import org.instancio.internal.selectors.Target;
import org.instancio.internal.selectors.TargetGetterReference;
import org.instancio.internal.selectors.TargetRoot;
import org.instancio.internal.selectors.TargetSetter;
import org.instancio.internal.selectors.TargetSetterReference;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.NotNull;

public final class SelectorProcessor {
    private final SetterSelectorHolder setMethodSelectorHolder;
    private final Target.TargetContext targetContext;

    public SelectorProcessor(Class<?> rootClass, List<InternalServiceProvider> internalServiceProviders, SetterSelectorHolder setMethodSelectorHolder) {
        this.setMethodSelectorHolder = setMethodSelectorHolder;
        this.targetContext = new Target.TargetContext(rootClass, internalServiceProviders);
    }

    public List<TargetSelector> process(@NotNull TargetSelector selector, @NotNull ApiMethodSelector apiMethodSelector) {
        if (selector instanceof SelectorImpl) {
            SelectorImpl result = this.processTargetAndScope((SelectorImpl)selector, apiMethodSelector);
            return Collections.singletonList(result);
        }
        if (selector instanceof SelectorGroupImpl) {
            return this.processGroup((SelectorGroupImpl)selector, apiMethodSelector);
        }
        if (selector instanceof GetMethodSelector) {
            return this.process(SelectorImpl.builder().apiMethodSelector(apiMethodSelector).target(new TargetGetterReference((GetMethodSelector)selector)).build(), apiMethodSelector);
        }
        if (selector instanceof SetMethodSelector) {
            return this.process(SelectorImpl.builder().apiMethodSelector(apiMethodSelector).target(new TargetSetterReference((SetMethodSelector)selector)).build(), apiMethodSelector);
        }
        if (selector instanceof PrimitiveAndWrapperSelectorImpl) {
            PrimitiveAndWrapperSelectorImpl ps = (PrimitiveAndWrapperSelectorImpl)selector;
            SelectorImpl.Builder primitiveBuilder = ps.getPrimitive().toBuilder().apiMethodSelector(apiMethodSelector);
            SelectorImpl.Builder wrapperBuilder = ps.getWrapper().toBuilder().apiMethodSelector(apiMethodSelector);
            if (ps.isScoped()) {
                List<Scope> scopes = this.createScopeWithRootClass(ps.getPrimitive().getScopes());
                return Arrays.asList(primitiveBuilder.scopes(scopes).build(), wrapperBuilder.scopes(scopes).build());
            }
            return Arrays.asList(primitiveBuilder.build(), wrapperBuilder.build());
        }
        if (selector instanceof PredicateSelectorImpl) {
            PredicateSelectorImpl ps = (PredicateSelectorImpl)selector;
            PredicateSelectorImpl processed = ps.toBuilder().apiMethodSelector(apiMethodSelector).scopes(this.createScopeWithRootClass(ps.getScopes())).build();
            return Collections.singletonList(processed);
        }
        SelectorBuilder builder = (SelectorBuilder)((Object)selector);
        return Collections.singletonList(builder.apiMethodSelector(apiMethodSelector).build());
    }

    @NotNull
    private SelectorImpl processTargetAndScope(SelectorImpl selector, ApiMethodSelector apiMethodSelector) {
        if (selector.getTarget() instanceof TargetRoot) {
            return selector.toBuilder().apiMethodSelector(apiMethodSelector).build();
        }
        List<Scope> processedScopes = this.createScopeWithRootClass(selector.getScopes());
        Target target = selector.getTarget().withRootClass(this.targetContext);
        SelectorImpl result = selector.toBuilder().apiMethodSelector(apiMethodSelector).target(target).scopes(processedScopes).build();
        if (result.getTarget() instanceof TargetSetter) {
            this.setMethodSelectorHolder.withSetterSelector(result);
        }
        return result;
    }

    private List<Scope> createScopeWithRootClass(List<Scope> scopes) {
        if (scopes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Scope> results = new ArrayList<Scope>(scopes.size());
        for (Scope s : scopes) {
            if (s instanceof ScopeImpl) {
                ScopeImpl scope = (ScopeImpl)s;
                Target unprocessed = scope.getTarget();
                Target processed = unprocessed.withRootClass(this.targetContext);
                results.add(new ScopeImpl(processed, scope.getDepth()));
                continue;
            }
            Verify.isTrue(s instanceof PredicateScopeImpl, "expected predicate scope", new Object[0]);
            results.add(s);
        }
        return results;
    }

    private List<TargetSelector> processGroup(SelectorGroupImpl selectorGroup, ApiMethodSelector apiMethodSelector) {
        List<TargetSelector> flattened = selectorGroup.flatten();
        ArrayList<TargetSelector> results = new ArrayList<TargetSelector>(flattened.size());
        for (TargetSelector selector : flattened) {
            results.addAll(this.process(selector, apiMethodSelector));
        }
        return results;
    }
}

