/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.instancio.exception.InstancioException;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.PredefinedNodeCreator;
import org.instancio.internal.nodes.SubtypeResolver;
import org.instancio.internal.nodes.TypeHelper;
import org.instancio.internal.nodes.resolvers.NodeKindResolverFacade;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.StringUtils;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeCreator {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCreator.class);
    private final PredefinedNodeCreator predefinedNodeCreator;
    private final ModelContext modelContext;
    private final TypeHelper typeHelper;
    private final NodeKindResolverFacade nodeKindResolverFacade;
    private final SubtypeResolver subtypeResolver;
    private final List<Pattern> ignorePatterns;

    NodeCreator(ModelContext modelContext) {
        this.modelContext = modelContext;
        this.typeHelper = new TypeHelper(modelContext.getRootType());
        this.nodeKindResolverFacade = new NodeKindResolverFacade(modelContext.getInternalServiceProviders());
        this.predefinedNodeCreator = new PredefinedNodeCreator(modelContext.getRootType(), this.nodeKindResolverFacade);
        this.subtypeResolver = new SubtypeResolver(modelContext);
        this.ignorePatterns = this.getIgnorePatterns(modelContext.getSettings());
    }

    private List<Pattern> getIgnorePatterns(Settings settings) {
        List<String> regexes = StringUtils.split(settings.get(Keys.IGNORE_FIELD_NAME_REGEXES));
        if (regexes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(regexes.size());
        for (String regex : regexes) {
            patterns.add(Pattern.compile(regex));
        }
        return Collections.unmodifiableList(patterns);
    }

    @Nullable
    InternalNode createNode(@NotNull Type type, @Nullable InternalNode parent) {
        return this.createNode(type, null, null, parent);
    }

    @Nullable
    InternalNode createNode(@NotNull Type type, @Nullable Member member, @Nullable Method setter, @Nullable InternalNode parent) {
        InternalNode node;
        InternalNode template;
        Verify.notNull(type, "'type' is null", new Object[0]);
        if (parent != null && parent.getDepth() >= this.modelContext.getMaxDepth()) {
            LOG.trace("Maximum depth ({}) reached {}", (Object)this.modelContext.getMaxDepth(), (Object)parent);
            return null;
        }
        if (this.shouldIgnoreMember(member)) {
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating node for: {}", (Object)Format.withoutPackage(type));
        }
        if ((template = this.predefinedNodeCreator.createFromTemplate(type, member, parent)) != null) {
            node = template;
        } else if (type instanceof Class) {
            node = this.fromClass((Class)type, member, setter, parent);
        } else if (type instanceof ParameterizedType) {
            node = this.fromParameterizedType((ParameterizedType)type, member, setter, parent);
        } else if (type instanceof TypeVariable) {
            node = this.fromTypeVariable((TypeVariable)type, member, setter, parent);
        } else if (type instanceof WildcardType) {
            node = this.fromWildcardType((WildcardType)type, member, setter, parent);
        } else if (type instanceof GenericArrayType) {
            node = this.fromGenericArrayNode((GenericArrayType)type, member, setter, parent);
        } else {
            throw new InstancioException("Unsupported type: " + type.getClass());
        }
        if (node != null && this.modelContext.isIgnored(node)) {
            node = node.toBuilder().nodeKind(NodeKind.IGNORED).build();
        }
        LOG.trace("Created node {} for type {}", (Object)node, (Object)type);
        return node;
    }

    private InternalNode fromWildcardType(WildcardType type, @Nullable Member member, @Nullable Method setter, @Nullable InternalNode parent) {
        return this.createNode(type.getUpperBounds()[0], member, setter, parent);
    }

    private InternalNode fromTypeVariable(TypeVariable<?> type, @Nullable Member member, @Nullable Method setter, @Nullable InternalNode parent) {
        Type resolvedType = this.typeHelper.resolveTypeVariable(type, parent);
        if (resolvedType == null) {
            LOG.warn("Unable to resolve type variable '{}'. Parent: {}", type, (Object)parent);
            return null;
        }
        return this.createNode(resolvedType, member, setter, parent);
    }

    private InternalNode.Builder builderTemplate(Type type, Class<?> rawType, Member member) {
        return InternalNode.builder(type, rawType, this.modelContext.getRootType()).member(member);
    }

    private InternalNode createNodeWithSubtypeMapping(Type type, @Nullable Member member, @Nullable Method setter, @Nullable InternalNode parent) {
        Class rawType = TypeUtils.getRawType(type);
        InternalNode node = this.builderTemplate(type, rawType, member).parent(parent).nodeKind(this.getNodeKind(rawType)).member(setter).build();
        Class targetClass = this.subtypeResolver.resolveSubtype(node).orElse(rawType);
        Map<Type, Type> genericSuperclassTypeMap = this.typeHelper.createSuperclassTypeMap(targetClass);
        if (!genericSuperclassTypeMap.isEmpty()) {
            node = node.toBuilder().additionalTypeMap(genericSuperclassTypeMap).build();
        }
        if (rawType != targetClass && !targetClass.isEnum() && !rawType.isPrimitive()) {
            ApiValidator.validateSubtype(rawType, targetClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Subtype mapping '{}' to '{}'", (Object)Format.withoutPackage(rawType), (Object)Format.withoutPackage(targetClass));
            }
            return node.toBuilder().targetClass(targetClass).nodeKind(this.getNodeKind(targetClass)).additionalTypeMap(this.typeHelper.createBridgeTypeMap(rawType, targetClass)).build();
        }
        return node;
    }

    private InternalNode fromClass(Class<?> type, @Nullable Member member, @Nullable Method setter, @Nullable InternalNode parent) {
        InternalNode node = this.createNodeWithSubtypeMapping(type, member, setter, parent);
        return node.hasAncestorWithSameTargetType() ? node.toBuilder().cyclic().build() : node;
    }

    private NodeKind getNodeKind(Class<?> rawType) {
        return this.nodeKindResolverFacade.getNodeKind(rawType);
    }

    private InternalNode fromParameterizedType(ParameterizedType type, @Nullable Member member, @Nullable Method setter, @Nullable InternalNode parent) {
        InternalNode node = this.createNodeWithSubtypeMapping(type, member, setter, parent);
        return node.hasAncestorWithSameTargetType() ? node.toBuilder().cyclic().build() : node;
    }

    private InternalNode fromGenericArrayNode(GenericArrayType type, @Nullable Member member, @Nullable Method setter, @Nullable InternalNode parent) {
        Type gcType = type.getGenericComponentType();
        if (gcType instanceof TypeVariable) {
            gcType = this.typeHelper.resolveTypeVariable((TypeVariable)gcType, parent);
        }
        return this.createArrayNodeWithSubtypeMapping(type, gcType, member, setter, parent);
    }

    private InternalNode createArrayNodeWithSubtypeMapping(Type arrayType, Type genericComponentType, @Nullable Member member, @Nullable Method setter, @Nullable InternalNode parent) {
        Class rawComponentType = TypeUtils.getRawType(genericComponentType);
        Class<?> arrayClass = TypeUtils.getArrayClass(rawComponentType);
        InternalNode node = this.builderTemplate(arrayType, arrayClass, member).parent(parent).nodeKind(NodeKind.ARRAY).member(setter).build();
        Class targetClass = this.subtypeResolver.resolveSubtype(node).orElse(rawComponentType);
        Class<?> targetClassComponentType = targetClass.getComponentType();
        if (!rawComponentType.isPrimitive() && targetClassComponentType != null && rawComponentType != targetClassComponentType) {
            ApiValidator.validateSubtype(rawComponentType, targetClassComponentType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Subtype mapping '{}' to '{}'", (Object)Format.withoutPackage(rawComponentType), (Object)Format.withoutPackage(targetClass));
            }
            Map<Type, Type> typeMapForSubtype = this.typeHelper.createBridgeTypeMap(rawComponentType, targetClassComponentType);
            typeMapForSubtype.put(rawComponentType, targetClassComponentType);
            return node.toBuilder().targetClass(targetClass).additionalTypeMap(typeMapForSubtype).build();
        }
        return node;
    }

    private boolean shouldIgnoreMember(@Nullable Member member) {
        if (!this.ignorePatterns.isEmpty() && member instanceof Field) {
            String fieldName = member.getName();
            for (Pattern p : this.ignorePatterns) {
                if (!p.matcher(fieldName).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

