/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import java.math.BigDecimal;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.FloatSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.math.BigDecimalGenerator;
import org.instancio.internal.generator.specs.InternalFractionalNumberGeneratorSpec;
import org.instancio.settings.Keys;

public class FloatGenerator
extends AbstractGenerator<Float>
implements FloatSpec,
InternalFractionalNumberGeneratorSpec<Float> {
    private final BigDecimalGenerator delegate;

    public FloatGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new BigDecimalGenerator(context).min(new BigDecimal(String.valueOf(context.getSettings().get(Keys.FLOAT_MIN)))).max(new BigDecimal(String.valueOf(context.getSettings().get(Keys.FLOAT_MAX)))).nullable(context.getSettings().get(Keys.FLOAT_NULLABLE));
    }

    @Override
    public String apiMethod() {
        return "floats()";
    }

    public FloatGenerator scale(int scale) {
        this.delegate.scale(scale);
        return this;
    }

    public FloatGenerator precision(int precision) {
        this.delegate.precision(precision);
        return this;
    }

    @Override
    public FloatGenerator min(Float min) {
        ApiValidator.notNull(min, "'min' must not be null");
        this.delegate.min(new BigDecimal(String.valueOf(min)));
        return this;
    }

    @Override
    public FloatGenerator max(Float max) {
        ApiValidator.notNull(max, "'max' must not be null");
        this.delegate.max(new BigDecimal(String.valueOf(max)));
        return this;
    }

    @Override
    public FloatGenerator range(Float min, Float max) {
        ApiValidator.notNull(min, "'min' must not be null");
        ApiValidator.notNull(max, "'max' must not be null");
        this.delegate.range(new BigDecimal(String.valueOf(min)), new BigDecimal(String.valueOf(max)));
        return this;
    }

    @Override
    public void ensureMinIsGreaterThanOrEqualTo(BigDecimal otherMin) {
        this.delegate.ensureMinIsGreaterThanOrEqualTo(otherMin);
    }

    @Override
    public void ensureMaxIsLessThanOrEqualTo(BigDecimal otherMax) {
        this.delegate.ensureMaxIsLessThanOrEqualTo(otherMax);
    }

    @Override
    public void integerMax(int integerMax) {
        this.delegate.integerMax(integerMax);
    }

    @Override
    public FloatGenerator nullable() {
        this.delegate.nullable();
        return this;
    }

    public FloatGenerator nullable(boolean isNullable) {
        this.delegate.nullable(isNullable);
        return this;
    }

    @Override
    public boolean isNullable() {
        return this.delegate.isNullable();
    }

    @Override
    protected Float tryGenerateNonNull(Random random) {
        return Float.valueOf(this.delegate.tryGenerateNonNull(random).floatValue());
    }

    @Override
    public Float generate(Random random) {
        BigDecimal result = (BigDecimal)this.delegate.generate(random);
        return result == null ? null : Float.valueOf(result.floatValue());
    }
}

