/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isBlank(@Nullable String s) {
        if (StringUtils.isEmpty(s)) {
            return true;
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String trimToEmpty(@Nullable String s) {
        return s == null ? "" : s.trim();
    }

    @Nullable
    public static String trimToNull(@Nullable String s) {
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    @Nullable
    public static String singleQuote(@Nullable String s) {
        return s == null ? null : "'" + s + "'";
    }

    public static String repeat(String s, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("Number of times must be positive: " + times);
        }
        StringBuilder sb = new StringBuilder(s.length() * times);
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean startsWithAny(@Nullable String s, String ... prefixes) {
        if (s == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String concatNonNull(String ... values) {
        StringBuilder sb = new StringBuilder();
        if (values != null) {
            for (String val : values) {
                if (val == null) continue;
                sb.append(val);
            }
        }
        return sb.toString();
    }

    public static String capitalise(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        String first = s.substring(0, 1).toUpperCase(Locale.getDefault());
        return s.length() == 1 ? first : first + s.substring(1);
    }

    public static <E extends Enum<E>> String enumToString(E val) {
        return val.getClass().getSimpleName() + "." + val.name();
    }

    public static String quoteStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return '\"' + value.toString() + '\"';
        }
        return value.toString();
    }

    public static List<String> getTemplateKeys(String template) {
        ArrayList<String> results = new ArrayList<String>();
        int length = template.length();
        int i = 0;
        while (i < length) {
            if (template.charAt(i) == '$' && i + 1 < length && template.charAt(i + 1) == '{') {
                int j = template.indexOf(125, i + 2);
                if (j == -1) {
                    throw Fail.withUsageError(ErrorMessageUtils.invalidStringTemplate(template, "unterminated template key"), new Object[0]);
                }
                String key = template.substring(i + 2, j);
                if (key.isEmpty() || key.contains("${")) {
                    String reason = String.format("invalid template key '${%s}'", key);
                    throw Fail.withUsageError(ErrorMessageUtils.invalidStringTemplate(template, reason), new Object[0]);
                }
                results.add(key);
                i = j + 1;
                continue;
            }
            ++i;
        }
        return results;
    }

    private StringUtils() {
    }
}

