/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.util.Objects;
import org.instancio.internal.selectors.Target;
import org.instancio.internal.selectors.TargetField;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TargetFieldName
implements Target {
    private final Class<?> targetClass;
    private final String fieldName;

    public TargetFieldName(@Nullable Class<?> targetClass, @NotNull String fieldName) {
        this.targetClass = targetClass;
        this.fieldName = fieldName;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Target withRootClass(Target.TargetContext targetContext) {
        Class<?> resolvedTargetClass = ObjectUtils.defaultIfNull(this.targetClass, targetContext.getRootClass());
        Field field = ReflectionUtils.getFieldOrNull(resolvedTargetClass, this.fieldName);
        if (field != null) {
            return new TargetField(field);
        }
        throw Fail.withUsageError("invalid field '%s' for %s", this.fieldName, resolvedTargetClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetFieldName)) {
            return false;
        }
        TargetFieldName that = (TargetFieldName)o;
        return Objects.equals(this.targetClass, that.targetClass) && Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        int result = this.targetClass != null ? this.targetClass.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }

    public String toString() {
        String s = "field(";
        if (this.targetClass != null) {
            s = s + this.targetClass.getSimpleName() + ", ";
        }
        s = s + '\"' + this.fieldName + "\")";
        return s;
    }
}

