/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.instancio.Node;
import org.instancio.internal.RootType;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.NodeTypeMap;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class InternalNode
implements Node {
    private final Type type;
    private final Class<?> rawType;
    private final Class<?> targetClass;
    private final Field field;
    private final Method setter;
    private final InternalNode parent;
    private final NodeKind nodeKind;
    private final boolean cyclic;
    private final NodeTypeMap nodeTypeMap;
    private List<InternalNode> children;
    private final int depth;
    private int hash;

    private InternalNode(Builder builder) {
        this.type = builder.type;
        this.rawType = builder.rawType;
        this.targetClass = builder.targetClass;
        this.field = builder.field;
        this.setter = builder.setter;
        this.parent = builder.parent;
        this.nodeKind = builder.nodeKind;
        this.cyclic = builder.cyclic;
        this.nodeTypeMap = builder.nodeTypeMap;
        this.children = CollectionUtils.asUnmodifiableList(builder.children);
        this.depth = this.parent == null ? 0 : this.parent.depth + 1;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public boolean is(NodeKind nodeKind) {
        return this.nodeKind == nodeKind;
    }

    public boolean isIgnored() {
        return this.nodeKind == NodeKind.IGNORED;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    boolean isContainer() {
        return this.is(NodeKind.COLLECTION) || this.is(NodeKind.MAP) || this.is(NodeKind.ARRAY) || this.is(NodeKind.CONTAINER);
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Method getSetter() {
        return this.setter;
    }

    @Override
    public InternalNode getParent() {
        return this.parent;
    }

    public NodeTypeMap getTypeMap() {
        return this.nodeTypeMap;
    }

    public InternalNode getOnlyChild() {
        Verify.state(this.getChildren().size() == 1, "Expected one child, but were %s", this.getChildren().size());
        return this.getChildren().get(0);
    }

    public List<InternalNode> getChildren() {
        return this.children;
    }

    void setChildren(List<InternalNode> children) {
        this.children = children;
    }

    boolean hasAncestorWithSameTargetType() {
        for (InternalNode ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
            if (this.nodeKind != NodeKind.POJO && this.nodeKind != NodeKind.RECORD || !Objects.equals(this.targetClass, ancestor.targetClass) || !Objects.equals(this.type, ancestor.type)) continue;
            return true;
        }
        return false;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalNode other = (InternalNode)o;
        return this.depth == other.depth && this.targetClass.equals(other.targetClass) && this.type.equals(other.type) && Objects.equals(this.field, other.field) && Objects.equals(this.setter, other.setter);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHashCode();
        }
        return this.hash;
    }

    private int computeHashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.targetClass.hashCode();
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        result = 31 * result + (this.setter != null ? this.setter.hashCode() : 0);
        result = 31 * result + this.depth;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50).append("Node[");
        if (this.field == null && this.setter == null) {
            sb.append(Format.withoutPackage(this.targetClass));
        } else {
            if (this.field != null) {
                sb.append(Format.withoutPackage(this.parent.targetClass)).append('.').append(this.field.getName());
                if (this.setter != null) {
                    sb.append(", ");
                }
            }
            if (this.setter != null) {
                sb.append(Format.formatSetterMethod(this.setter));
            }
        }
        sb.append(", depth=").append(this.depth).append(", type=").append(Format.withoutPackage(this.type));
        if (this.nodeKind == NodeKind.IGNORED) {
            sb.append(", IGNORED");
        }
        return sb.append(']').toString();
    }

    public String toDisplayString() {
        if (this.nodeKind == NodeKind.IGNORED) {
            return "ignored";
        }
        StringBuilder sb = new StringBuilder(32);
        if (this.field == null && this.setter == null) {
            return sb.append("class ").append(Format.withoutPackage(this.type)).toString();
        }
        if (this.field != null) {
            sb.append("field ").append(Format.withoutPackage(this.field.getDeclaringClass())).append('.').append(this.field.getName());
        }
        if (this.setter != null) {
            if (this.field != null) {
                sb.append(", ");
            }
            sb.append("setter ").append(Format.withoutPackage(this.setter.getDeclaringClass())).append('.').append(this.setter.getName()).append('(').append(this.setter.getParameterTypes()[0].getSimpleName()).append(')');
        }
        return sb.toString();
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type, this.rawType, this.nodeTypeMap.getRootType());
        builder.targetClass = this.targetClass;
        builder.field = this.field;
        builder.setter = this.setter;
        builder.parent = this.parent;
        builder.children = this.children;
        builder.nodeKind = this.nodeKind;
        builder.cyclic = this.cyclic;
        builder.nodeTypeMap = this.nodeTypeMap;
        return builder;
    }

    public static Builder builder(Type type, Class<?> rawType, RootType rootType) {
        return new Builder(type, rawType, rootType);
    }

    public static final class Builder {
        private final Type type;
        private final Class<?> rawType;
        private final RootType rootType;
        private Class<?> targetClass;
        private Field field;
        private Method setter;
        private InternalNode parent;
        private List<InternalNode> children;
        private NodeKind nodeKind;
        private boolean cyclic;
        private NodeTypeMap nodeTypeMap;
        private Map<Type, Type> additionalTypeMap = Collections.emptyMap();

        private Builder(Type type, Class<?> rawType, RootType rootType) {
            this.type = type;
            this.rawType = rawType;
            this.rootType = rootType;
        }

        public Builder targetClass(Class<?> targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public Builder member(@Nullable Member member) {
            if (member instanceof Field) {
                return this.member((Field)member);
            }
            if (member instanceof Method) {
                return this.member((Method)member);
            }
            return this;
        }

        public Builder member(@Nullable Field field) {
            this.field = field;
            return this;
        }

        public Builder member(@Nullable Method setter) {
            this.setter = setter;
            return this;
        }

        public Builder parent(@Nullable InternalNode parent) {
            this.parent = parent;
            return this;
        }

        public Builder children(List<InternalNode> children) {
            this.children = children;
            return this;
        }

        public Builder nodeKind(NodeKind nodeKind) {
            this.nodeKind = nodeKind;
            return this;
        }

        public Builder cyclic() {
            this.cyclic = true;
            return this;
        }

        public Builder additionalTypeMap(Map<Type, Type> additionalTypeMap) {
            this.additionalTypeMap = additionalTypeMap;
            return this;
        }

        public InternalNode build() {
            this.targetClass = ObjectUtils.defaultIfNull(this.targetClass, this.rawType);
            this.nodeTypeMap = new NodeTypeMap(this.type, this.rootType, this.additionalTypeMap);
            return new InternalNode(this);
        }
    }
}

