/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import java.math.BigDecimal;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.DoubleSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.math.BigDecimalGenerator;
import org.instancio.internal.generator.specs.InternalFractionalNumberGeneratorSpec;
import org.instancio.settings.Keys;

public class DoubleGenerator
extends AbstractGenerator<Double>
implements DoubleSpec,
InternalFractionalNumberGeneratorSpec<Double> {
    private final BigDecimalGenerator delegate;

    public DoubleGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new BigDecimalGenerator(context).min(new BigDecimal(String.valueOf(context.getSettings().get(Keys.DOUBLE_MIN)))).max(new BigDecimal(String.valueOf(context.getSettings().get(Keys.DOUBLE_MAX)))).nullable(context.getSettings().get(Keys.DOUBLE_NULLABLE));
    }

    @Override
    public String apiMethod() {
        return "doubles()";
    }

    public DoubleGenerator scale(int scale) {
        this.delegate.scale(scale);
        return this;
    }

    public DoubleGenerator precision(int precision) {
        this.delegate.precision(precision);
        return this;
    }

    @Override
    public DoubleGenerator min(Double min) {
        ApiValidator.notNull(min, "'min' must not be null");
        this.delegate.min(new BigDecimal(String.valueOf(min)));
        return this;
    }

    @Override
    public DoubleGenerator max(Double max) {
        ApiValidator.notNull(max, "'max' must not be null");
        this.delegate.max(new BigDecimal(String.valueOf(max)));
        return this;
    }

    @Override
    public DoubleGenerator range(Double min, Double max) {
        ApiValidator.notNull(min, "'min' must not be null");
        ApiValidator.notNull(max, "'max' must not be null");
        this.delegate.range(new BigDecimal(String.valueOf(min)), new BigDecimal(String.valueOf(max)));
        return this;
    }

    @Override
    public void ensureMinIsGreaterThanOrEqualTo(BigDecimal otherMin) {
        this.delegate.ensureMinIsGreaterThanOrEqualTo(otherMin);
    }

    @Override
    public void ensureMaxIsLessThanOrEqualTo(BigDecimal otherMax) {
        this.delegate.ensureMaxIsLessThanOrEqualTo(otherMax);
    }

    @Override
    public void integerMax(int integerMax) {
        this.delegate.integerMax(integerMax);
    }

    @Override
    public DoubleGenerator nullable() {
        this.delegate.nullable();
        return this;
    }

    public DoubleGenerator nullable(boolean isNullable) {
        this.delegate.nullable(isNullable);
        return this;
    }

    @Override
    public boolean isNullable() {
        return this.delegate.isNullable();
    }

    @Override
    protected Double tryGenerateNonNull(Random random) {
        return this.delegate.tryGenerateNonNull(random).doubleValue();
    }

    @Override
    public Double generate(Random random) {
        BigDecimal result = (BigDecimal)this.delegate.generate(random);
        return result == null ? null : Double.valueOf(result.doubleValue());
    }
}

