/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class SortedSetWithReverseInsertionOrder<E>
implements Set<E> {
    private final Set<Entry<E>> set = new TreeSet<Entry<E>>((o1, o2) -> {
        int c = comparator.compare(((Entry)o1).element, ((Entry)o2).element);
        if (c == 0) {
            return ((Entry)o2).insertionOrder - ((Entry)o1).insertionOrder;
        }
        return c;
    });

    SortedSetWithReverseInsertionOrder(Comparator<E> comparator) {
    }

    @Override
    public boolean add(E e) {
        return this.set.add(new Entry(this.size(), e));
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl(this.set.iterator());
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(@NotNull T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private static final class Entry<E> {
        private final int insertionOrder;
        private final E element;

        private Entry(int insertionOrder, E element) {
            this.insertionOrder = insertionOrder;
            this.element = element;
        }
    }

    private static final class IteratorImpl<E>
    implements Iterator<E> {
        private final Iterator<Entry<E>> delegate;

        private IteratorImpl(Iterator<Entry<E>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return (E)((Entry)this.delegate.next()).element;
        }
    }
}

