/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;

final class FillObjectHelper {
    private FillObjectHelper() {
    }

    static List<Type> getTypeArgs(Object object) {
        Type[] typeArgs;
        if (object.getClass().getTypeParameters().length == 0) {
            return Collections.emptyList();
        }
        if (object instanceof Collection) {
            typeArgs = FillObjectHelper.getCollectionTypeArgs((Collection)object);
        } else if (object instanceof Map) {
            typeArgs = FillObjectHelper.getMapTypeArgs((Map)object);
        } else {
            throw Fail.withUsageError(ErrorMessageUtils.fillParameterizedType(object.getClass()), new Object[0]);
        }
        ApiValidator.doesNotContainNull(typeArgs, () -> "the fill() method cannot resolve type arguments from the given " + object.getClass().getSimpleName() + " instance because it contains null value(s)");
        return CollectionUtils.asUnmodifiableList(typeArgs);
    }

    private static Type[] getCollectionTypeArgs(Collection<?> collection) {
        ApiValidator.isFalse(collection.isEmpty(), "cannot fill() an empty collection", new Object[0]);
        Type[] typeArgs = new Type[1];
        for (Object element : collection) {
            if (typeArgs[0] == null) {
                typeArgs[0] = FillObjectHelper.getType(element);
            }
            if (typeArgs[0] == null) continue;
            break;
        }
        return typeArgs;
    }

    private static Type[] getMapTypeArgs(Map<?, ?> map) {
        ApiValidator.isFalse(map.isEmpty(), "cannot fill() an empty map", new Object[0]);
        Type[] typeArgs = new Type[2];
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (typeArgs[0] == null) {
                typeArgs[0] = FillObjectHelper.getType(entry.getKey());
            }
            if (typeArgs[1] == null) {
                typeArgs[1] = FillObjectHelper.getType(entry.getValue());
            }
            if (typeArgs[0] == null || typeArgs[1] == null) continue;
            break;
        }
        return typeArgs;
    }

    private static Class<?> getType(Object o) {
        return o == null ? null : o.getClass();
    }
}

