/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.instancio.DepthPredicateSelector;
import org.instancio.DepthSelector;
import org.instancio.Scope;
import org.instancio.ScopeableSelector;
import org.instancio.TargetSelector;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.Flattener;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.SelectorBuilder;
import org.instancio.internal.util.ErrorMessageUtils;

abstract class PredicateSelectorBuilderTemplate<T>
implements SelectorBuilder,
DepthSelector,
DepthPredicateSelector,
Flattener<TargetSelector> {
    private final List<Predicate<T>> predicates = new ArrayList<Predicate<T>>(3);
    private final StringBuilder description = new StringBuilder(128);
    private ApiMethodSelector apiMethodSelector;
    private List<Scope> scopes;
    private boolean isLenient;

    PredicateSelectorBuilderTemplate() {
        this.description.append(this.apiMethod());
    }

    protected abstract PredicateSelectorImpl.Builder createBuilder();

    protected abstract String apiMethod();

    protected final void addPredicate(Predicate<T> predicate) {
        this.predicates.add(predicate);
    }

    protected final StringBuilder description() {
        return this.description;
    }

    @Override
    public final SelectorBuilder apiMethodSelector(ApiMethodSelector apiMethodSelector) {
        this.apiMethodSelector = apiMethodSelector;
        return this;
    }

    @Override
    public final ScopeableSelector atDepth(int depth) {
        PredicateSelectorImpl copy = this.build();
        return copy.toBuilder().depth(depth).build();
    }

    @Override
    public final ScopeableSelector atDepth(Predicate<Integer> predicate) {
        PredicateSelectorImpl copy = this.build();
        return copy.toBuilder().depth(predicate).build();
    }

    protected final void setLenient() {
        this.isLenient = true;
    }

    protected final void withScopes(Scope ... scopes) {
        ApiValidator.notNull(scopes, () -> ErrorMessageUtils.selectorNotNullErrorMessage("scopes must not be null.", "within", this.description().toString(), new Throwable()));
        ApiValidator.doesNotContainNull(scopes, () -> ErrorMessageUtils.selectorNotNullErrorMessage("scopes vararg must not contain null.", "within", this.description().toString(), new Throwable()));
        this.scopes = Arrays.asList(scopes);
    }

    protected final Predicate<T> buildPredicate() {
        Predicate<Object> predicate = Objects::nonNull;
        for (Predicate<T> p : this.predicates) {
            predicate = predicate.and(p);
        }
        return predicate;
    }

    @Override
    public final PredicateSelectorImpl build() {
        PredicateSelectorImpl.Builder builder = this.createBuilder();
        if (this.scopes != null) {
            builder.scopes(this.scopes);
        }
        if (this.isLenient) {
            builder.lenient();
        }
        return builder.apiMethodSelector(this.apiMethodSelector).apiInvocationDescription(this.description.toString()).build();
    }

    @Override
    public List<TargetSelector> flatten() {
        return Collections.singletonList(this.build());
    }

    public final String toString() {
        return this.description.toString();
    }
}

