/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.util.Set;
import org.instancio.feed.Feed;
import org.instancio.feed.FeedSpec;
import org.instancio.generator.Generator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.feed.InternalFeedSpecResolver;
import org.instancio.internal.nodes.InternalFeedSpecHandler;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.selectors.FeedSelectors;
import org.instancio.internal.selectors.InternalSelector;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.settings.Keys;
import org.instancio.settings.OnFeedPropertyUnmatched;

final class DefaultFeedSpecHandler
implements InternalFeedSpecHandler {
    private static final InternalFeedSpecHandler NOOP_HANDLER = node -> {};
    private final ModelContext modelContext;
    private final SelectorMap<Feed> feedSelectorMap;

    private DefaultFeedSpecHandler(ModelContext modelContext) {
        this.modelContext = modelContext;
        this.feedSelectorMap = modelContext.getFeedSelectorMap();
    }

    static InternalFeedSpecHandler create(ModelContext modelContext) {
        SelectorMap<Feed> map = modelContext.getFeedSelectorMap();
        return map.isEmpty() ? NOOP_HANDLER : new DefaultFeedSpecHandler(modelContext);
    }

    @Override
    public void applyFeedSpecs(InternalNode node) {
        if (node.isIgnored() || !node.is(NodeKind.POJO) && !node.is(NodeKind.RECORD)) {
            return;
        }
        Feed feed = this.feedSelectorMap.getValue(node).orElse(null);
        if (feed == null) {
            return;
        }
        InternalFeedSpecResolver specsResolver = new InternalFeedSpecResolver(feed);
        for (InternalNode child : node.getChildren()) {
            FeedSpec<?> spec = specsResolver.getSpec(child);
            if (spec == null) continue;
            InternalSelector selector = FeedSelectors.forProperty(child);
            this.modelContext.putGenerator(selector, (Generator)((Object)spec));
        }
        OnFeedPropertyUnmatched onFeedPropertyUnmatched = this.modelContext.getSettings().get(Keys.ON_FEED_PROPERTY_UNMATCHED);
        Set<String> unmappedProperties = specsResolver.getUnmappedFeedProperties();
        if (onFeedPropertyUnmatched == OnFeedPropertyUnmatched.FAIL && !unmappedProperties.isEmpty()) {
            throw Fail.withUsageError(ErrorMessageUtils.unmappedFeedProperties(unmappedProperties, this.modelContext.getSettings()), new Object[0]);
        }
    }
}

