/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import java.lang.annotation.Annotation;
import java.util.List;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.PrimitiveWrapperBiLookup;
import org.instancio.internal.annotation.AnnotationExtractor;
import org.instancio.internal.annotation.AnnotationLibraries;
import org.instancio.internal.annotation.AnnotationLibraryFacade;
import org.instancio.internal.annotation.AnnotationMap;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.AnnotationProcessorHelper;
import org.instancio.internal.generation.GeneratedValuePostProcessor;
import org.instancio.internal.generation.NodeHandler;
import org.instancio.internal.generation.StringPrefixingPostProcessor;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.settings.Keys;
import org.instancio.spi.InstancioServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AnnotationNodeHandler
implements NodeHandler {
    private final List<AnnotationLibraryFacade> annotationLibraryFacades;
    private final AnnotationExtractor annotationExtractor;
    private final ModelContext modelContext;
    private final GeneratorContext generatorContext;
    private final GeneratorResolver generatorResolver;
    private final GeneratedValuePostProcessor stringPostProcessor;
    private final AnnotationProcessorHelper annotationProcessorMethods;
    private final boolean beanValidationOrJpaEnabled;

    private AnnotationNodeHandler(ModelContext modelContext, GeneratorResolver generatorResolver, List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> annotationProcessors, boolean beanValidationOrJpaEnabled) {
        this.modelContext = modelContext;
        this.generatorResolver = generatorResolver;
        this.annotationLibraryFacades = AnnotationLibraries.discoverOnClasspath(modelContext);
        this.annotationExtractor = new AnnotationExtractor(modelContext);
        this.stringPostProcessor = new StringPrefixingPostProcessor(modelContext.getSettings().get(Keys.STRING_FIELD_PREFIX_ENABLED));
        this.generatorContext = new GeneratorContext(modelContext.getSettings(), modelContext.getRandom());
        this.annotationProcessorMethods = new AnnotationProcessorHelper(annotationProcessors);
        this.beanValidationOrJpaEnabled = beanValidationOrJpaEnabled;
    }

    static NodeHandler create(ModelContext context, GeneratorResolver generatorResolver) {
        boolean bvOrJpaEnabled = context.getSettings().get(Keys.BEAN_VALIDATION_ENABLED) != false || context.getSettings().get(Keys.JPA_ENABLED) != false;
        List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> annotationProcessors = context.getServiceProviders().getAnnotationProcessors();
        return bvOrJpaEnabled || !annotationProcessors.isEmpty() ? new AnnotationNodeHandler(context, generatorResolver, annotationProcessors, bvOrJpaEnabled) : NOOP_HANDLER;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        Generator<?> generator;
        Annotation[] annotations = this.annotationExtractor.getAnnotations(node);
        if (annotations.length == 0) {
            return GeneratorResult.emptyResult();
        }
        if (this.beanValidationOrJpaEnabled) {
            AnnotationMap annotationMap = new AnnotationMap(annotations);
            generator = this.getGenerator(node, annotations, annotationMap);
            for (AnnotationLibraryFacade lib : this.annotationLibraryFacades) {
                lib.consumeAnnotations(annotationMap, generator, node.getTargetClass());
            }
        } else {
            generator = this.generatorResolver.get(node);
        }
        if (generator == null) {
            return GeneratorResult.emptyResult();
        }
        this.invokeAnnotationHandlerMethods(node, annotations, generator);
        Object obj = generator.generate(this.modelContext.getRandom());
        if (node.getTargetClass() == String.class) {
            obj = obj.toString();
        } else if (!AnnotationNodeHandler.isObjectAssignableToNode(node, obj)) {
            Generator<?> builtInGenerator = this.generatorResolver.get(node);
            obj = builtInGenerator.generate(this.modelContext.getRandom());
        }
        Object processed = this.stringPostProcessor.process(obj, node, generator);
        return GeneratorResult.create(processed, generator.hints());
    }

    private void invokeAnnotationHandlerMethods(InternalNode node, Annotation[] annotations, Generator<?> generator) {
        for (Annotation annotation : annotations) {
            List<AnnotationProcessorHelper.AnnotatedMethod> annotatedMethods = this.annotationProcessorMethods.get(annotation.annotationType());
            for (AnnotationProcessorHelper.AnnotatedMethod method : annotatedMethods) {
                method.invoke(annotation, generator, node);
            }
        }
    }

    private static boolean isObjectAssignableToNode(InternalNode node, Object obj) {
        if (obj == null) {
            return true;
        }
        Class<?> targetClass = node.getTargetClass();
        if (targetClass.isPrimitive()) {
            targetClass = PrimitiveWrapperBiLookup.getEquivalent(targetClass);
        }
        return targetClass.isAssignableFrom(obj.getClass());
    }

    @Nullable
    private Generator<?> getGenerator(InternalNode node, Annotation[] annotations, AnnotationMap annotationMap) {
        for (AnnotationLibraryFacade provider : this.annotationLibraryFacades) {
            for (Annotation annotation : annotations) {
                if (!provider.isPrimary(annotation.annotationType())) continue;
                annotationMap.setPrimary(annotation);
                return provider.resolveGenerator(annotation, this.generatorContext);
            }
        }
        return this.generatorResolver.get(node);
    }
}

